/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.states.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.exceptions.EndpointTimeOutException;
import org.wso2.transport.http.netty.contract.exceptions.ResetStreamException;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2StateUtil;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2DataEventListener;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.http2.OutboundMsgHolder;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.ReceivingEntityBody;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.ReceivingHeaders;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.RequestCompleted;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.SenderState;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.Http2PushPromise;

public class SendingEntityBody
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(SendingEntityBody.class);
    private final Http2TargetHandler http2TargetHandler;
    private final Http2MessageStateContext http2MessageStateContext;
    private final OutboundMsgHolder outboundMsgHolder;
    private final Http2ConnectionEncoder encoder;
    private final Http2ClientChannel http2ClientChannel;
    private final int streamId;
    private final Http2TargetHandler.Http2RequestWriter http2RequestWriter;

    public SendingEntityBody(Http2TargetHandler http2TargetHandler, Http2TargetHandler.Http2RequestWriter http2RequestWriter) {
        this.http2TargetHandler = http2TargetHandler;
        this.http2MessageStateContext = http2RequestWriter.getHttp2MessageStateContext();
        this.outboundMsgHolder = http2RequestWriter.getOutboundMsgHolder();
        this.encoder = http2TargetHandler.getEncoder();
        this.http2ClientChannel = http2TargetHandler.getHttp2ClientChannel();
        this.streamId = http2RequestWriter.getStreamId();
        this.http2RequestWriter = http2RequestWriter;
    }

    @Override
    public void writeOutboundRequestHeaders(ChannelHandlerContext ctx, HttpContent httpContent) {
        LOG.warn("writeOutboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundRequestBody(ChannelHandlerContext ctx, HttpContent httpContent, Http2MessageStateContext http2MessageStateContext) throws Http2Exception {
        this.writeContent(ctx, httpContent);
    }

    @Override
    public void readInboundResponseHeaders(ChannelHandlerContext ctx, Http2HeadersFrame http2HeadersFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) throws Http2Exception {
        http2MessageStateContext.setSenderState(new ReceivingHeaders(this.http2TargetHandler, this.http2RequestWriter));
        http2MessageStateContext.getSenderState().readInboundResponseHeaders(ctx, http2HeadersFrame, outboundMsgHolder, serverPush, http2MessageStateContext);
    }

    @Override
    public void readInboundResponseBody(ChannelHandlerContext ctx, Http2DataFrame http2DataFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) {
        http2MessageStateContext.setSenderState(new ReceivingEntityBody(this.http2TargetHandler, this.http2RequestWriter));
        http2MessageStateContext.getSenderState().readInboundResponseBody(ctx, http2DataFrame, outboundMsgHolder, serverPush, http2MessageStateContext);
    }

    @Override
    public void readInboundPromise(ChannelHandlerContext ctx, Http2PushPromise http2PushPromise, OutboundMsgHolder outboundMsgHolder) {
        Http2StateUtil.onPushPromiseRead(ctx, http2PushPromise, this.http2ClientChannel, outboundMsgHolder);
    }

    @Override
    public void handleStreamTimeout(OutboundMsgHolder outboundMsgHolder, boolean serverPush, ChannelHandlerContext ctx, int streamId) {
        if (!serverPush) {
            outboundMsgHolder.getResponseFuture().notifyHttpListener(new EndpointTimeOutException("Idle timeout triggered while writing outbound request entity body", HttpResponseStatus.INTERNAL_SERVER_ERROR.code()));
        }
    }

    @Override
    public void handleConnectionClose(OutboundMsgHolder outboundMsgHolder) {
        outboundMsgHolder.getRequest().setIoException(new IOException("Remote host closed the connection while writing outbound request entity body"));
        outboundMsgHolder.getResponseFuture().notifyHttpListener(new EndpointTimeOutException("Remote host closed the connection while writing outbound request entity body", HttpResponseStatus.GATEWAY_TIMEOUT.code()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContent(ChannelHandlerContext ctx, HttpContent msg) throws Http2Exception {
        if (msg.decoderResult().isFailure()) {
            msg.release();
            Object http2Error = this.outboundMsgHolder.getRequest().getProperty("Http2Error");
            ResetStreamException streamReset = new ResetStreamException("Stream was reset", http2Error == null ? Http2Error.STREAM_CLOSED.code() : ((Http2Error)((Object)http2Error)).code());
            long errorCode = http2Error == null ? Http2Error.STREAM_CLOSED.code() : ((Http2Error)((Object)http2Error)).code();
            this.outboundMsgHolder.getResponseFuture().notifyHttpListener(streamReset);
            this.encoder.writeRstStream(ctx, this.streamId, errorCode, ctx.newPromise());
            this.http2ClientChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamReset(this.streamId));
            ctx.flush();
            return;
        }
        boolean release = true;
        try {
            boolean endStream = msg instanceof LastHttpContent;
            ByteBuf content = msg.content();
            release = false;
            for (Http2DataEventListener dataEventListener2 : this.http2ClientChannel.getDataEventListeners()) {
                if (dataEventListener2.onDataWrite(ctx, this.streamId, content, endStream)) continue;
                return;
            }
            this.encoder.writeData(ctx, this.streamId, content, 0, endStream, ctx.newPromise());
            this.encoder.flowController().writePendingBytes();
            ctx.flush();
            if (endStream) {
                this.outboundMsgHolder.setRequestWritten(true);
                this.http2MessageStateContext.setSenderState(new RequestCompleted(this.http2TargetHandler, this.http2RequestWriter));
            }
        }
        finally {
            if (release) {
                ReferenceCountUtil.release(msg);
            }
        }
    }
}

