/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.jms.receiver;

import org.wso2.transport.jms.contract.JMSListener;
import org.wso2.transport.jms.exception.JMSConnectorException;
import org.wso2.transport.jms.factory.JMSServerConnectionFactory;
import org.wso2.transport.jms.receiver.JMSMessageConsumer;

public class JMSMessageConsumerBuilder {
    private JMSServerConnectionFactory connectionFactory = null;
    private boolean useReceiver = false;
    private String serviceId;
    private JMSListener jmsListener;
    private long retryInterval = 10000L;
    private int maxRetryCount = 5;

    public JMSMessageConsumerBuilder(JMSServerConnectionFactory connectionFactory, JMSListener jmsListener, String serviceId) {
        this.connectionFactory = connectionFactory;
        this.jmsListener = jmsListener;
        this.serviceId = serviceId;
    }

    public JMSMessageConsumerBuilder setUseReceiver(boolean useReceiver) {
        this.useReceiver = useReceiver;
        return this;
    }

    public JMSMessageConsumerBuilder setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    public JMSMessageConsumerBuilder setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        return this;
    }

    public JMSMessageConsumer build() throws JMSConnectorException {
        return new JMSMessageConsumer(this.connectionFactory, this.useReceiver, this.jmsListener, this.serviceId, this.retryInterval, this.maxRetryCount);
    }
}

