/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.mqtt.source;

import io.siddhi.core.stream.input.source.SourceEventListener;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttConsumer {
    private static final Logger log = Logger.getLogger(MqttConsumer.class);
    public SourceEventListener sourceEventListener;
    private boolean isPaused;
    private ReentrantLock lock;
    private Condition condition;

    public MqttConsumer(SourceEventListener sourceEventListener) {
        this.sourceEventListener = sourceEventListener;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    public void subscribe(String topicOption, int qosOption, MqttClient client) throws MqttException {
        MqttSourceCallBack callback = new MqttSourceCallBack();
        client.setCallback(callback);
        client.subscribe(topicOption, qosOption);
    }

    public void pause() {
        this.isPaused = true;
    }

    public void resume() {
        this.isPaused = false;
        try {
            this.lock.lock();
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public class MqttSourceCallBack
    implements MqttCallback {
        @Override
        public void connectionLost(Throwable throwable) {
            log.debug((Object)"MQTT connection not reachable");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
            if (MqttConsumer.this.isPaused) {
                MqttConsumer.this.lock.lock();
                try {
                    while (!MqttConsumer.this.isPaused) {
                        MqttConsumer.this.condition.await();
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    MqttConsumer.this.lock.unlock();
                }
            }
            String message = new String(mqttMessage.getPayload(), "UTF-8");
            MqttConsumer.this.sourceEventListener.onEvent((Object)message, null);
        }

        @Override
        public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
        }
    }
}

