/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.tcp.source;

import io.siddhi.extension.io.tcp.transport.TCPNettyServer;
import io.siddhi.extension.io.tcp.transport.callback.StreamListener;
import io.siddhi.extension.io.tcp.transport.config.ServerConfig;

public class TCPServer {
    private static TCPServer ourInstance = new TCPServer();
    private TCPNettyServer tcpNettyServer = new TCPNettyServer();
    private boolean started = false;

    private TCPServer() {
    }

    public static TCPServer getInstance() {
        return ourInstance;
    }

    public synchronized void start(ServerConfig serverConfig) {
        if (!this.started) {
            this.tcpNettyServer.start(serverConfig);
            this.started = true;
        }
    }

    public synchronized void stop() {
        if (this.started && this.tcpNettyServer.getNoOfRegisteredStreamListeners() == 0) {
            try {
                this.tcpNettyServer.shutdownGracefully();
            }
            finally {
                this.started = false;
            }
        }
    }

    public synchronized void addStreamListener(StreamListener streamListener) {
        this.tcpNettyServer.addStreamListener(streamListener);
    }

    public synchronized void removeStreamListener(String streamId) {
        this.tcpNettyServer.removeStreamListener(streamId);
    }

    public void pause() {
        this.tcpNettyServer.pause();
    }

    public void resume() {
        this.tcpNettyServer.resume();
    }
}

