/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.tcp.transport.utils;

import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.extension.io.tcp.transport.callback.StreamListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StreamListenerHolder {
    private Map<String, StreamListener> streamListenerMap = new ConcurrentHashMap<String, StreamListener>();

    public StreamListener getStreamListener(String streamId) {
        return this.streamListenerMap.get(streamId);
    }

    public void putStreamCallback(StreamListener streamListener) {
        if (this.streamListenerMap.containsKey(streamListener.getChannelId())) {
            throw new SiddhiAppCreationException("TCP source for channelId '" + streamListener.getChannelId() + "' already defined !");
        }
        this.streamListenerMap.put(streamListener.getChannelId(), streamListener);
    }

    public void removeStreamCallback(String streamId) {
        this.streamListenerMap.remove(streamId);
    }

    public int getNoOfRegisteredStreamListeners() {
        return this.streamListenerMap.size();
    }
}

