/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.tcp.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.extension.io.tcp.transport.handlers.MessageEncoder;
import io.siddhi.extension.io.tcp.transport.utils.EventComposite;
import java.util.UUID;
import org.apache.log4j.Logger;

public class TCPNettyClient {
    private static final Logger log = Logger.getLogger(TCPNettyClient.class);
    private EventLoopGroup group;
    private Bootstrap bootstrap;
    private Channel channel;
    private String sessionId;
    private String hostAndPort;

    public TCPNettyClient(boolean keepAlive, boolean noDelay) {
        this(0, keepAlive, noDelay);
    }

    public TCPNettyClient() {
        this(0, true, true);
    }

    public TCPNettyClient(int numberOfThreads, boolean keepAlive, boolean noDelay) {
        this.group = new NioEventLoopGroup(numberOfThreads);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)keepAlive)).option(ChannelOption.TCP_NODELAY, (Object)noDelay)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addFirst(new ChannelHandler[]{new MessageEncoder()});
            }
        });
    }

    public void connect(String host, int port) throws ConnectionUnavailableException {
        try {
            this.hostAndPort = host + ":" + port;
            this.channel = this.bootstrap.connect(host, port).sync().channel();
            this.sessionId = UUID.randomUUID() + "-" + this.hostAndPort;
        }
        catch (Throwable e) {
            throw new ConnectionUnavailableException("Error connecting to '" + this.hostAndPort + "', " + e.getMessage(), e);
        }
    }

    public ChannelFuture send(String channelId, byte[] message) {
        EventComposite eventComposite = new EventComposite(this.sessionId, channelId, message);
        ChannelFuture cf = this.channel.writeAndFlush((Object)eventComposite);
        return cf;
    }

    public void disconnect() {
        if (this.channel != null && this.channel.isOpen()) {
            try {
                this.channel.close();
                this.channel.closeFuture().sync();
            }
            catch (InterruptedException e) {
                log.error((Object)("Error closing connection to '" + this.hostAndPort + "' from client '" + this.sessionId + "', " + e));
            }
            this.channel.disconnect();
            log.info((Object)("Disconnecting client to '" + this.hostAndPort + "' with sessionId:" + this.sessionId));
        }
    }

    public void shutdown() {
        this.disconnect();
        if (this.group != null) {
            this.group.shutdownGracefully();
        }
        log.info((Object)("Stopping client to '" + this.hostAndPort + "' with sessionId:" + this.sessionId));
        this.hostAndPort = null;
        this.sessionId = null;
    }
}

