/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.tcp.transport.callback;

import io.siddhi.core.event.Event;
import io.siddhi.extension.io.tcp.transport.callback.StreamListener;
import io.siddhi.extension.map.binary.sourcemapper.SiddhiEventConverter;
import io.siddhi.extension.map.binary.utils.EventDefinitionConverterUtil;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class StatisticsStreamListener
implements StreamListener {
    private static final Logger log = Logger.getLogger(StatisticsStreamListener.class);
    private AtomicLong totalDelay = new AtomicLong(0L);
    private AtomicLong lastIndex = new AtomicLong(0L);
    private AtomicLong lastCounter = new AtomicLong(0L);
    private AtomicLong lastTime = new AtomicLong(System.currentTimeMillis());
    private AtomicLong maxLatency = new AtomicLong(0L);
    private AtomicLong minLatency = new AtomicLong(Long.MAX_VALUE);
    private AtomicLong counter = new AtomicLong(0L);
    private AtomicBoolean calcInProgress = new AtomicBoolean(false);
    private DecimalFormat decimalFormat = new DecimalFormat("#.#####");
    private int elapsedCount = 1000000;
    private PrintWriter writer = null;
    private StreamDefinition streamDefinition;
    private Attribute.Type[] types;

    public StatisticsStreamListener(StreamDefinition streamDefinition) {
        this.streamDefinition = streamDefinition;
        this.types = EventDefinitionConverterUtil.generateAttributeTypeArray((List)streamDefinition.getAttributeList());
    }

    @Override
    public String getChannelId() {
        return this.streamDefinition.getId();
    }

    @Override
    public void onMessage(byte[] message) {
        this.onEvents(SiddhiEventConverter.toConvertToSiddhiEvents((ByteBuffer)ByteBuffer.wrap(message), (Attribute.Type[])this.types));
    }

    private void onEvents(Event[] events) {
        for (Event event : events) {
            this.onEvent(event);
        }
    }

    private void onEvent(Event event) {
        try {
            long currentMinLatency;
            long currentBatchTotalDelay = 0L;
            long currentTime = System.currentTimeMillis();
            long currentEventLatency = System.currentTimeMillis() - event.getTimestamp();
            long currentMaxLatency = this.maxLatency.get();
            if (currentEventLatency > currentMaxLatency) {
                this.maxLatency.compareAndSet(currentMaxLatency, currentEventLatency);
            }
            if (currentEventLatency < (currentMinLatency = this.minLatency.get())) {
                this.minLatency.compareAndSet(currentMinLatency, currentEventLatency);
            }
            long localCounter = this.counter.incrementAndGet();
            long localTotalDelay = this.totalDelay.addAndGet(currentBatchTotalDelay += currentEventLatency);
            long index = localCounter / (long)this.elapsedCount;
            if (this.lastIndex.get() != index && this.calcInProgress.compareAndSet(false, true)) {
                this.lastIndex.set(index);
                long currentWindowEventsReceived = localCounter - this.lastCounter.getAndSet(localCounter);
                long elapsedTime = currentTime - this.lastTime.getAndSet(currentTime);
                log.info((Object)("Received " + currentWindowEventsReceived + " events in " + elapsedTime + " ms; Throughput - Avg : " + this.decimalFormat.format((double)currentWindowEventsReceived * 1000.0 / (double)elapsedTime) + " ; Latency - Avg: " + this.decimalFormat.format((double)localTotalDelay / (double)currentWindowEventsReceived) + ", Min: " + this.minLatency.get() + ", Max: " + this.maxLatency.get()));
                this.writeResult(localCounter + "," + this.decimalFormat.format((double)localTotalDelay / (double)currentWindowEventsReceived) + "," + this.decimalFormat.format((double)currentWindowEventsReceived * 1000.0 / (double)elapsedTime));
                this.maxLatency.set(0L);
                this.minLatency.set(Long.MAX_VALUE);
                this.totalDelay.addAndGet(-localTotalDelay);
                this.calcInProgress.set(false);
            }
        }
        catch (Exception e) {
            log.info((Object)("Error while consuming event on " + this.streamDefinition.getId() + ", " + e.getMessage()));
        }
    }

    private void writeResult(String data) {
        try {
            if (this.writer == null) {
                this.writer = new PrintWriter("results.csv", StandardCharsets.UTF_8.name());
            }
        }
        catch (FileNotFoundException ex) {
            log.error((Object)"File not found......");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("File writing encoding is wrong, found '" + StandardCharsets.UTF_8.name() + "'"));
        }
        this.writer.println(data);
        this.writer.flush();
    }
}

