/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.tcp.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.siddhi.extension.io.tcp.transport.callback.StreamListener;
import io.siddhi.extension.io.tcp.transport.config.ServerConfig;
import io.siddhi.extension.io.tcp.transport.handlers.MessageDecoder;
import io.siddhi.extension.io.tcp.transport.utils.FlowController;
import io.siddhi.extension.io.tcp.transport.utils.StreamListenerHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TCPNettyServer {
    private static final Logger log = LogManager.getLogger(TCPNettyServer.class);
    private ServerBootstrap bootstrap;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private StreamListenerHolder streamInfoHolder = new StreamListenerHolder();
    private ChannelFuture channelFuture;
    private String hostAndPort;
    private ServerConfig serverConfig;
    private FlowController flowController = new FlowController();

    public void start(ServerConfig serverConf) {
        this.serverConfig = serverConf;
        this.bossGroup = new NioEventLoopGroup(this.serverConfig.getReceiverThreads());
        this.workerGroup = new NioEventLoopGroup(this.serverConfig.getWorkerThreads());
        this.hostAndPort = this.serverConfig.getHost() + ":" + this.serverConfig.getPort();
        this.bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel channel) throws Exception {
                ChannelPipeline p = channel.pipeline();
                p.addLast(new ChannelHandler[]{new MessageDecoder(TCPNettyServer.this.streamInfoHolder, TCPNettyServer.this.flowController)});
            }
        }).option(ChannelOption.TCP_NODELAY, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        try {
            this.channelFuture = this.bootstrap.bind(this.serverConfig.getHost(), this.serverConfig.getPort()).sync();
            log.info("Tcp Server started in " + this.hostAndPort + "");
        }
        catch (InterruptedException e) {
            log.error("Error when booting up tcp server on '" + this.hostAndPort + "' " + e.getMessage(), (Throwable)e);
        }
    }

    public void shutdownGracefully() {
        this.channelFuture.channel().close();
        try {
            this.channelFuture.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            log.error("Error when shutdowning the tcp server " + e.getMessage(), (Throwable)e);
        }
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
        log.info("Tcp Server running on '" + this.hostAndPort + "' stopped.");
        this.workerGroup = null;
        this.bossGroup = null;
    }

    public synchronized void addStreamListener(StreamListener streamListener) {
        this.streamInfoHolder.putStreamCallback(streamListener);
    }

    public synchronized void removeStreamListener(String streamId) {
        this.streamInfoHolder.removeStreamCallback(streamId);
    }

    public synchronized int getNoOfRegisteredStreamListeners() {
        return this.streamInfoHolder.getNoOfRegisteredStreamListeners();
    }

    public void pause() {
        this.flowController.pause();
    }

    public void resume() {
        this.flowController.resume();
    }
}

