/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.tcp.transport.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.siddhi.extension.io.tcp.transport.callback.StreamListener;
import io.siddhi.extension.io.tcp.transport.utils.BinaryMessageConverterUtil;
import io.siddhi.extension.io.tcp.transport.utils.FlowController;
import io.siddhi.extension.io.tcp.transport.utils.StreamListenerHolder;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageDecoder
extends ByteToMessageDecoder {
    private static final Logger LOG = LogManager.getLogger(MessageDecoder.class);
    private StreamListenerHolder streamInfoHolder;
    private FlowController flowController;

    public MessageDecoder(StreamListenerHolder streamInfoHolder, FlowController flowController) {
        this.streamInfoHolder = streamInfoHolder;
        this.flowController = flowController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 5) {
            return;
        }
        try {
            byte protocol = in.readByte();
            int messageSize = in.readInt();
            if (protocol != 2 || messageSize > in.readableBytes()) {
                in.resetReaderIndex();
                return;
            }
            this.flowController.barrier();
            int sessionIdSize = in.readInt();
            BinaryMessageConverterUtil.getString(in, sessionIdSize);
            int channelIdSize = in.readInt();
            String channelId = BinaryMessageConverterUtil.getString(in, channelIdSize);
            int dataLength = in.readInt();
            byte[] bytes = new byte[dataLength];
            in.readBytes(bytes);
            StreamListener streamListener = this.streamInfoHolder.getStreamListener(channelId);
            if (streamListener == null) {
                in.markReaderIndex();
                LOG.error("Events with unknown channelId : '" + channelId + "' hence dropping the events!");
                return;
            }
            streamListener.onMessage(bytes);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            in.markReaderIndex();
        }
    }
}

