/*
 *  Copyright (c) 2018, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 *  WSO2 Inc. licenses this file to you under the Apache License,
 *  Version 2.0 (the "License"); you may not use this file except
 *  in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */

package io.siddhi.extension.io.websocket.sink.websocketserver;

import io.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;

import java.util.List;

/**
 * Future listener for WebSocket handshake.
 */

public class WebSocketServerHandshakeListener implements ServerHandshakeListener {
    private List<WebSocketConnection> webSocketConnectionList;

    WebSocketServerHandshakeListener(List<WebSocketConnection> webSocketConnectionList) {
        this.webSocketConnectionList = webSocketConnectionList;
    }

    @Override
    public void onSuccess(WebSocketConnection webSocketConnection) {
        webSocketConnectionList.add(webSocketConnection);
        webSocketConnection.startReadingFrames();
    }

    @Override
    public void onError(Throwable throwable) {
        throw new SiddhiAppRuntimeException("Error occurred while starting the connection ", throwable);
    }
}
