/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.websocket.sink;

import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.wso2.transport.http.netty.contract.websocket.ClientHandshakeListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.message.HttpCarbonResponse;

public class WebSocketSinkHandshakeListener
implements ClientHandshakeListener {
    private StreamDefinition streamDefinition;
    private AtomicReference<WebSocketConnection> webSocketConnectionAtomicReference = new AtomicReference();
    private Semaphore semaphore;

    public WebSocketSinkHandshakeListener(StreamDefinition streamDefinition, Semaphore semaphore) {
        this.streamDefinition = streamDefinition;
        this.semaphore = semaphore;
    }

    public void onSuccess(WebSocketConnection webSocketConnection, HttpCarbonResponse response) {
        this.webSocketConnectionAtomicReference.set(webSocketConnection);
        this.semaphore.release();
    }

    public void onError(Throwable t, HttpCarbonResponse response) {
        this.semaphore.release();
        throw new SiddhiAppRuntimeException("Error while connecting with the websocket server defined in '" + this.streamDefinition + "'.", t);
    }

    public AtomicReference<WebSocketConnection> getWebSocketConnectionAtomicReference() {
        return this.webSocketConnectionAtomicReference;
    }
}

