/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.websocket.sink.websocketserver;

import io.siddhi.extension.io.websocket.sink.websocketserver.WebSocketServerSinkConnectorListener;
import io.siddhi.query.api.definition.StreamDefinition;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.config.ListenerConfiguration;
import org.wso2.transport.http.netty.contract.config.ServerBootstrapConfiguration;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpWsConnectorFactory;

class WebSocketServer {
    private final String host;
    private final int webSocketPort;
    private ServerConnector serverConnector = null;
    private String keystorePath;
    private String keystorePassword;
    private boolean isSslEnabled;
    private WebSocketServerSinkConnectorListener serverSinkConnectorListener;

    WebSocketServer(String host, int port, String[] subProtocols, int idleTimeout, boolean isTlsEnabled, String keystorePath, String keystorePassword, StreamDefinition streamDefinition) {
        this.host = host;
        this.webSocketPort = port;
        this.isSslEnabled = isTlsEnabled;
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.serverSinkConnectorListener = new WebSocketServerSinkConnectorListener(subProtocols, idleTimeout, streamDefinition);
    }

    void start() throws InterruptedException {
        ListenerConfiguration listenerConfiguration = new ListenerConfiguration();
        if (this.isSslEnabled) {
            listenerConfiguration.setScheme("https");
            listenerConfiguration.setKeyStoreFile(this.keystorePath);
            listenerConfiguration.setKeyStorePass(this.keystorePassword);
        }
        listenerConfiguration.setHost(this.host);
        listenerConfiguration.setPort(this.webSocketPort);
        DefaultHttpWsConnectorFactory httpConnectorFactory = new DefaultHttpWsConnectorFactory();
        this.serverConnector = httpConnectorFactory.createServerConnector(new ServerBootstrapConfiguration(null), listenerConfiguration);
        ServerConnectorFuture connectorFuture = this.serverConnector.start();
        connectorFuture.setWebSocketConnectorListener((WebSocketConnectorListener)this.serverSinkConnectorListener);
        connectorFuture.sync();
    }

    void stop() {
        if (this.serverConnector != null) {
            this.serverConnector.stop();
        }
    }

    void send(Object message) {
        this.serverSinkConnectorListener.send(message);
    }
}

