/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.websocket.sink.websocketserver;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.stream.ServiceDeploymentInfo;
import io.siddhi.core.stream.output.sink.Sink;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.transport.DynamicOptions;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.extension.io.websocket.sink.websocketserver.WebSocketServer;
import io.siddhi.extension.io.websocket.util.WebSocketUtil;
import io.siddhi.query.api.definition.StreamDefinition;
import java.nio.ByteBuffer;

@Extension(name="websocket-server", namespace="sink", description="A Siddhi application can be configured to publish events via the WebSocket transport by adding the @Sink(type = 'websocket-server') annotation at the top of an event stream definition.", parameters={@Parameter(name="host", description="host of the WebSocket server", type={DataType.STRING}), @Parameter(name="port", description="port of the WebSocket server", type={DataType.STRING}), @Parameter(name="sub.protocol", description="Sub-Protocols which are allowed by the service.\nThe sub.protocol should adhere to `subprotocol1, subprotocol2,...` format.", type={DataType.STRING}, optional=true, defaultValue="null"), @Parameter(name="idle.timeout", description="Idle timeout of the connection. If the idle.timeout = '-1' then the timer is disabled.", type={DataType.INT}, optional=true, defaultValue="-1"), @Parameter(name="tls.enabled", description="This parameter specifies whether a secure connection is enabled or not. When this parameter is set to `true`, the `keystore.path` and the `keystore.password` parameters are initialized.", type={DataType.BOOL}, optional=true, defaultValue="false"), @Parameter(name="keystore.path", description="The file path to the location of the keystore. If a custom keystore is not specified, then the system uses the default keystore file - wso2carbon.jks in the `${carbon.home}/resources/security` directory.", type={DataType.STRING}, optional=true, defaultValue="${carbon.home}/resources/security/wso2carbon.jks"), @Parameter(name="keystore.password", description="The password for the keystore. A custom password can be specified if required. If no custom password is specified, then the system uses `wso2carbon` as the default password.", type={DataType.STRING}, optional=true, defaultValue="wso2carbon")}, examples={@Example(syntax="@Sink(type = 'websocket-server', host='localhost', port='9025', \n   @map(type='xml'))\ndefine stream Foo (attribute1 string, attribute2 int);", description="A sink of type 'websocket-server' has been defined.\nAll events arriving at Foo stream via websocket-server will be sent to the url ws://localhost:9025/abc.")})
public class WebSocketServerSink
extends Sink {
    private String host;
    private String[] subProtocols = null;
    private int port;
    private boolean isTlsEnabled;
    private int idleTimeout;
    private String tlsKeystorePath;
    private String tlsKeystorePassword;
    private StreamDefinition streamDefinition;
    private WebSocketServer websocketServer = null;
    private static final String[] SUPPORTED_DYNAMIC_OPTIONS = new String[0];

    public Class[] getSupportedInputEventClasses() {
        return new Class[]{String.class, ByteBuffer.class};
    }

    public String[] getSupportedDynamicOptions() {
        return SUPPORTED_DYNAMIC_OPTIONS;
    }

    protected StateFactory init(StreamDefinition streamDefinition, OptionHolder optionHolder, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        this.host = optionHolder.validateAndGetStaticValue("host");
        this.port = Integer.parseInt(optionHolder.validateAndGetStaticValue("port"));
        String subProtocolString = optionHolder.validateAndGetStaticValue("sub.protocol", null);
        if (subProtocolString != null) {
            this.subProtocols = WebSocketUtil.getSubProtocol(subProtocolString);
        }
        this.idleTimeout = Integer.parseInt(optionHolder.validateAndGetStaticValue("idle.timeout", "-1"));
        this.isTlsEnabled = Boolean.parseBoolean(optionHolder.validateAndGetStaticValue("tls.enabled", "false"));
        this.tlsKeystorePath = optionHolder.validateAndGetStaticValue("keystore.path", configReader.readConfig("keystore.path", "${carbon.home}/resources/security/wso2carbon.jks"));
        this.tlsKeystorePassword = optionHolder.validateAndGetStaticValue("keystore.password", configReader.readConfig("keystore.password", "wso2carbon"));
        this.streamDefinition = streamDefinition;
        return null;
    }

    protected ServiceDeploymentInfo exposeServiceDeploymentInfo() {
        return null;
    }

    public void publish(Object payload, DynamicOptions dynamicOptions, State state) throws ConnectionUnavailableException {
        this.websocketServer.send(payload);
    }

    public void connect() throws ConnectionUnavailableException {
        try {
            this.websocketServer = new WebSocketServer(this.host, this.port, this.subProtocols, this.idleTimeout, this.isTlsEnabled, this.tlsKeystorePath, this.tlsKeystorePassword, this.streamDefinition);
            this.websocketServer.start();
        }
        catch (InterruptedException e) {
            throw new ConnectionUnavailableException("Error while starting the WebSocket server defined in " + this.streamDefinition + ".", (Throwable)e);
        }
    }

    public void disconnect() {
        if (this.websocketServer != null) {
            this.websocketServer.stop();
        }
    }

    public void destroy() {
    }
}

