/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.websocket.sink.websocketserver;

import io.siddhi.extension.io.websocket.sink.websocketserver.WebSocketServerHandshakeListener;
import io.siddhi.query.api.definition.StreamDefinition;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;

public class WebSocketServerSinkConnectorListener
implements WebSocketConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServerSinkConnectorListener.class);
    private List<WebSocketConnection> webSocketConnectionList = new CopyOnWriteArrayList<WebSocketConnection>();
    private String[] subProtocol = null;
    private int idleTimeout;

    WebSocketServerSinkConnectorListener(String[] subProtocol, int idleTimeout, StreamDefinition streamDefinition) {
        this.subProtocol = subProtocol;
        this.idleTimeout = idleTimeout;
    }

    public void onHandshake(WebSocketHandshaker webSocketHandshaker) {
        WebSocketServerHandshakeListener serverHandshakeListener = new WebSocketServerHandshakeListener(this.webSocketConnectionList);
        ServerHandshakeFuture handshake = webSocketHandshaker.handshake(this.subProtocol, this.idleTimeout);
        handshake.setHandshakeListener((ServerHandshakeListener)serverHandshakeListener);
    }

    void send(Object message) {
        this.webSocketConnectionList.forEach(currentWebSocketConnection -> {
            if (message instanceof ByteBuffer) {
                byte[] byteMessage = ((ByteBuffer)message).array();
                ByteBuffer binaryMessage = ByteBuffer.wrap(byteMessage);
                currentWebSocketConnection.pushBinary(binaryMessage);
            } else {
                currentWebSocketConnection.pushText((String)message);
            }
        });
    }

    public void onMessage(WebSocketTextMessage textMessage) {
    }

    public void onMessage(WebSocketBinaryMessage binaryMessage) {
    }

    public void onMessage(WebSocketControlMessage controlMessage) {
    }

    public void onMessage(WebSocketCloseMessage closeMessage) {
    }

    public void onError(WebSocketConnection webSocketConnection, Throwable throwable) {
        this.webSocketConnectionList.remove(webSocketConnection);
    }

    public void onClose(WebSocketConnection webSocketConnection) {
        this.webSocketConnectionList.remove(webSocketConnection);
    }

    public void onIdleTimeout(WebSocketControlMessage controlMessage) {
        WebSocketConnection webSocketConnection = controlMessage.getWebSocketConnection();
        webSocketConnection.terminateConnection(1001, "Connection timeout");
    }
}

