/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.websocket.source.websocketserver;

import io.siddhi.core.stream.input.source.SourceEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;

public class WebSocketServerSourceConnectorListener
implements WebSocketConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServerSourceConnectorListener.class);
    private String[] subProtocols = null;
    private int idleTimeout;
    private SourceEventListener sourceEventListener = null;
    private static WebSocketSourceHandShakeListener webSocketSourceHandShakeListener = new WebSocketSourceHandShakeListener();

    WebSocketServerSourceConnectorListener(String[] subProtocols, int idleTimeout, SourceEventListener sourceEventListener) {
        this.subProtocols = subProtocols;
        this.idleTimeout = idleTimeout;
        this.sourceEventListener = sourceEventListener;
    }

    public void onHandshake(WebSocketHandshaker webSocketHandshaker) {
        webSocketHandshaker.handshake(this.subProtocols, this.idleTimeout).setHandshakeListener((ServerHandshakeListener)webSocketSourceHandShakeListener);
    }

    public void onMessage(WebSocketTextMessage textMessage) {
        String receivedTextToClient = textMessage.getText();
        if (this.sourceEventListener != null) {
            this.sourceEventListener.onEvent((Object)receivedTextToClient, null);
        }
    }

    public void onMessage(WebSocketBinaryMessage binaryMessage) {
        byte[] receivedBinaryMessage = binaryMessage.getByteArray();
        if (this.sourceEventListener != null) {
            this.sourceEventListener.onEvent((Object)receivedBinaryMessage, null);
        }
    }

    public void onMessage(WebSocketControlMessage controlMessage) {
    }

    public void onMessage(WebSocketCloseMessage closeMessage) {
    }

    public void onClose(WebSocketConnection webSocketConnection) {
    }

    public void onError(WebSocketConnection webSocketConnection, Throwable throwable) {
    }

    public void onIdleTimeout(WebSocketControlMessage controlMessage) {
        WebSocketConnection webSocketConnection = controlMessage.getWebSocketConnection();
        webSocketConnection.terminateConnection(1001, "Connection timeout");
    }

    private static class WebSocketSourceHandShakeListener
    implements ServerHandshakeListener {
        private WebSocketSourceHandShakeListener() {
        }

        public void onSuccess(WebSocketConnection webSocketConnection) {
            webSocketConnection.startReadingFrames();
        }

        public void onError(Throwable throwable) {
            log.error("Error occurred while receiving messages : " + throwable.getMessage());
        }
    }
}

