/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.websocket.source.websocketserver;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.stream.ServiceDeploymentInfo;
import io.siddhi.core.stream.input.source.Source;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.extension.io.websocket.source.websocketserver.WebSocketServer;
import io.siddhi.extension.io.websocket.util.WebSocketUtil;
import java.nio.ByteBuffer;

@Extension(name="websocket-server", namespace="source", description="A Siddhi application can be configured to receive events via the WebSocket by adding the @Source(type = 'websocket-server') annotation at the top of an event stream definition.", parameters={@Parameter(name="host", description="host of the WebSocket server", type={DataType.STRING}), @Parameter(name="port", description="port of the WebSocket server", type={DataType.STRING}), @Parameter(name="sub.protocol", description="Sub-Protocols which are allowed by the service.\nThe sub.protocol should adhere to `subprotocol1, subprotocol2,...` format.", type={DataType.STRING}, optional=true, defaultValue="null"), @Parameter(name="idle.timeout", description="Idle timeout of the connection. If the idle.timeout = '-1' then the timer is disabled.", type={DataType.INT}, optional=true, defaultValue="-1"), @Parameter(name="tls.enabled", description="This parameter specifies whether a secure connection is enabled or not. When this parameter is set to `true`, the `keystore.path` and the `keystore.password` parameters are initialized.", type={DataType.BOOL}, optional=true, defaultValue="false"), @Parameter(name="keystore.path", description="The file path to the location of the keystore. If a custom keystore is not specified, then the system uses the default keystore file - wso2carbon.jks in the `${carbon.home}/resources/security` directory.", type={DataType.STRING}, optional=true, defaultValue="${carbon.home}/resources/security/wso2carbon.jks"), @Parameter(name="keystore.password", description="The password for the keystore. A custom password can be specified if required. If no custom password is specified, then the system uses `wso2carbon` as the default password.", type={DataType.STRING}, optional=true, defaultValue="wso2carbon")}, examples={@Example(syntax="@Source(type = 'websocket-server', host='localhost', port='8025', \n   @map(type='xml'))\ndefine stream Foo (attribute1 string, attribute2 int);", description="Under this configuration, events are received via the WebSocket server and they are passed to `Foo` stream for processing. ")})
public class WebSocketServerSource
extends Source {
    private String host;
    private String[] subProtocols = null;
    private int port;
    private boolean isTlsEnabled;
    private int idleTimeout;
    private String tlsKeystorePath;
    private String tlsKeystorePassword;
    private WebSocketServer websocketServer = null;
    private SourceEventListener sourceEventListener;

    public StateFactory init(SourceEventListener sourceEventListener, OptionHolder optionHolder, String[] transportProperties, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        this.host = optionHolder.validateAndGetStaticValue("host");
        this.port = Integer.parseInt(optionHolder.validateAndGetStaticValue("port"));
        String subProtocolString = optionHolder.validateAndGetStaticValue("sub.protocol", null);
        if (subProtocolString != null) {
            this.subProtocols = WebSocketUtil.getSubProtocol(subProtocolString);
        }
        this.idleTimeout = Integer.parseInt(optionHolder.validateAndGetStaticValue("idle.timeout", "-1"));
        this.isTlsEnabled = Boolean.parseBoolean(optionHolder.validateAndGetStaticValue("tls.enabled", "false"));
        this.tlsKeystorePath = optionHolder.validateAndGetStaticValue("keystore.path", configReader.readConfig("keystore.path", "${carbon.home}/resources/security/wso2carbon.jks"));
        this.tlsKeystorePassword = optionHolder.validateAndGetStaticValue("keystore.password", configReader.readConfig("keystore.password", "wso2carbon"));
        this.sourceEventListener = sourceEventListener;
        return null;
    }

    protected ServiceDeploymentInfo exposeServiceDeploymentInfo() {
        return new ServiceDeploymentInfo(this.port, this.isTlsEnabled);
    }

    public Class[] getOutputEventClasses() {
        return new Class[]{String.class, ByteBuffer.class};
    }

    public void connect(Source.ConnectionCallback connectionCallback, State state) throws ConnectionUnavailableException {
        try {
            this.websocketServer = new WebSocketServer(this.host, this.port, this.subProtocols, this.idleTimeout, this.isTlsEnabled, this.tlsKeystorePath, this.tlsKeystorePassword, this.sourceEventListener);
            this.websocketServer.start();
        }
        catch (InterruptedException e) {
            throw new ConnectionUnavailableException("Error while starting the WebSocket server defined in " + this.sourceEventListener.getStreamDefinition() + ".", (Throwable)e);
        }
    }

    public void disconnect() {
        if (this.websocketServer != null) {
            this.websocketServer.stop();
        }
    }

    public void destroy() {
    }

    public void pause() {
    }

    public void resume() {
    }
}

