/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.websocket.util;

import io.siddhi.core.stream.input.source.SourceEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;

public class WebSocketClientConnectorListener
implements WebSocketConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(WebSocketConnectorListener.class);
    private SourceEventListener sourceEventListener = null;

    public void setSourceEventListener(SourceEventListener eventListener) {
        this.sourceEventListener = eventListener;
    }

    public void onHandshake(WebSocketHandshaker webSocketHandshaker) {
    }

    public void onMessage(WebSocketTextMessage textMessage) {
        String receivedTextMessage = textMessage.getText();
        if (this.sourceEventListener != null) {
            this.sourceEventListener.onEvent((Object)receivedTextMessage, null);
        }
    }

    public void onMessage(WebSocketBinaryMessage binaryMessage) {
        byte[] receivedBinaryMessage = binaryMessage.getByteArray();
        if (this.sourceEventListener != null) {
            this.sourceEventListener.onEvent((Object)receivedBinaryMessage, null);
        }
    }

    public void onMessage(WebSocketControlMessage controlMessage) {
    }

    public void onMessage(WebSocketCloseMessage closeMessage) {
    }

    public void onClose(WebSocketConnection webSocketConnection) {
    }

    public void onError(WebSocketConnection webSocketConnection, Throwable throwable) {
        log.error("There is an error in the message format.", throwable);
    }

    public void onIdleTimeout(WebSocketControlMessage webSocketControlMessage) {
    }
}

