/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.map.xml.sinkmapper;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.stream.output.sink.SinkListener;
import io.siddhi.core.stream.output.sink.SinkMapper;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.transport.Option;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.core.util.transport.TemplateBuilder;
import io.siddhi.query.api.definition.StreamDefinition;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

@Extension(name="xml", namespace="sinkMapper", description="This mapper converts Siddhi output events to XML before they are published via transports that publish in XML format. Users can either send a pre-defined XML format or a custom XML message containing event data.", parameters={@Parameter(name="validate.xml", description="This parameter specifies whether the XML messages generated should be validated or not. If this parameter is set to true, messages that do not adhere to proper XML standards are dropped. ", type={DataType.BOOL}, optional=true, defaultValue="false"), @Parameter(name="enclosing.element", description="When an enclosing element is specified, the child elements (e.g., the immediate child elements) of that element are considered as events. This is useful when you need to send multiple events in a single XML message. When an enclosing element is not specified, one XML message per every event will be emitted without enclosing.", type={DataType.STRING}, optional=true, defaultValue="None in custom mapping and &lt;events&gt; in default mapping")}, examples={@Example(syntax="@sink(type='inMemory', topic='stock', @map(type='xml'))\ndefine stream FooStream (symbol string, price float, volume long);\n", description="Above configuration will do a default XML input mapping which will generate below output\n<events>\n    <event>\n        <symbol>WSO2</symbol>\n        <price>55.6</price>\n        <volume>100</volume>\n    </event>\n</events>\n"), @Example(syntax="@sink(type='inMemory', topic='{{symbol}}', @map(type='xml', enclosing.element='<portfolio>', validate.xml='true', @payload( \"<StockData><Symbol>{{symbol}}</Symbol><Price>{{price}}</Price></StockData>\")))\ndefine stream BarStream (symbol string, price float, volume long);", description="Above configuration will perform a custom XML mapping. Inside @payload you can specify the custom template that you want to send the messages out and addd placeholders to places where you need to add event attributes.Above config will produce below output XML message\n<portfolio>\n    <StockData>\n        <Symbol>WSO2</Symbol>\n        <Price>55.6</Price>\n    </StockData>\n</portfolio>")})
public class XMLSinkMapper
extends SinkMapper {
    private static final Logger log = LogManager.getLogger(XMLSinkMapper.class);
    private static final String EVENTS_PARENT_OPENING_TAG = "<events>";
    private static final String EVENTS_PARENT_CLOSING_TAG = "</events>";
    private static final String EVENT_PARENT_OPENING_TAG = "<event>";
    private static final String EVENT_PARENT_CLOSING_TAG = "</event>";
    private static final String OPTION_ENCLOSING_ELEMENT = "enclosing.element";
    private static final String OPTION_VALIDATE_XML = "validate.xml";
    private static final String NS_XSI_NIL_ENABLE = " xsi:nil=\"true\"/";
    private StreamDefinition streamDefinition;
    private String enclosingElement = null;
    private boolean xmlValidationEnabled = false;
    private DocumentBuilder builder;
    private String endingElement = "";

    public String[] getSupportedDynamicOptions() {
        return new String[0];
    }

    public Class[] getOutputEventClasses() {
        return new Class[]{String.class};
    }

    public void init(StreamDefinition streamDefinition, OptionHolder optionHolder, Map<String, TemplateBuilder> payloadTemplateBuilderMap, ConfigReader mapperConfigReader, SiddhiAppContext siddhiAppContext) {
        Option validateXmlOption;
        this.streamDefinition = streamDefinition;
        this.enclosingElement = optionHolder.getOrCreateOption(OPTION_ENCLOSING_ELEMENT, null).getValue();
        if (this.enclosingElement != null) {
            this.endingElement = this.getClosingElement(this.enclosingElement);
        }
        if ((validateXmlOption = optionHolder.getOrCreateOption(OPTION_VALIDATE_XML, null)) != null) {
            this.xmlValidationEnabled = Boolean.parseBoolean(validateXmlOption.getValue());
            if (this.xmlValidationEnabled) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                try {
                    factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    factory.setXIncludeAware(false);
                    factory.setExpandEntityReferences(false);
                    this.builder = factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new SiddhiAppCreationException("Error occurred when initializing XML validator", (Throwable)e);
                }
            }
        }
        if (payloadTemplateBuilderMap != null && payloadTemplateBuilderMap.size() != 1) {
            throw new SiddhiAppCreationException("Xml sink-mapper does not support multiple @payload mappings, error at the mapper of '" + streamDefinition.getId() + "'");
        }
        if (payloadTemplateBuilderMap != null && payloadTemplateBuilderMap.get(payloadTemplateBuilderMap.keySet().iterator().next()).isObjectMessage()) {
            throw new SiddhiAppCreationException("Xml sink-mapper does not support object @payload mappings, error at the mapper of '" + streamDefinition.getId() + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapAndSend(Event event, OptionHolder optionHolder, Map<String, TemplateBuilder> payloadTemplateBuilderMap, SinkListener sinkListener) {
        StringBuilder sb = new StringBuilder();
        if (payloadTemplateBuilderMap != null) {
            if (this.enclosingElement != null) {
                sb.append(this.enclosingElement);
            }
            sb.append(payloadTemplateBuilderMap.get(payloadTemplateBuilderMap.keySet().iterator().next()).build(event));
            sb.append(this.endingElement);
            if (this.xmlValidationEnabled) {
                try {
                    this.builder.parse(new ByteArrayInputStream(sb.toString().getBytes(Charset.forName("UTF-8"))));
                }
                catch (SAXException e) {
                    log.error("Parse error occurred when validating output XML event. Reason: " + e.getMessage() + "Dropping event: " + sb.toString());
                    return;
                }
                catch (IOException e) {
                    log.error("IO error occurred when validating output XML event. Reason: " + e.getMessage() + "Dropping event: " + sb.toString());
                    return;
                }
                finally {
                    this.builder.reset();
                }
            }
        } else {
            sb.append(this.constructDefaultMapping(event));
            if (this.enclosingElement != null) {
                sb.insert(0, this.enclosingElement);
                sb.append(this.endingElement);
            } else {
                sb.insert(0, EVENTS_PARENT_OPENING_TAG);
                sb.append(EVENTS_PARENT_CLOSING_TAG);
            }
        }
        sinkListener.publish((Object)sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapAndSend(Event[] events, OptionHolder optionHolder, Map<String, TemplateBuilder> payloadTemplateBuilderMap, SinkListener sinkListener) {
        if (events.length < 1) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (payloadTemplateBuilderMap != null) {
            if (this.enclosingElement != null) {
                sb.append(this.enclosingElement);
            }
            for (Event event : events) {
                sb.append(payloadTemplateBuilderMap.get(payloadTemplateBuilderMap.keySet().iterator().next()).build(event));
            }
            sb.append(this.endingElement);
            if (this.xmlValidationEnabled) {
                try {
                    this.builder.parse(new ByteArrayInputStream(sb.toString().getBytes(Charset.forName("UTF-8"))));
                }
                catch (IOException | SAXException e) {
                    log.error("Error occurred when validating output XML event. Reason: " + e.getMessage() + "Dropping event: " + sb.toString());
                    return;
                }
                finally {
                    this.builder.reset();
                }
            }
        } else {
            for (Event event : events) {
                sb.append(this.constructDefaultMapping(event));
            }
            if (this.enclosingElement != null) {
                sb.insert(0, this.enclosingElement);
                sb.append(this.endingElement);
            } else {
                sb.insert(0, EVENTS_PARENT_OPENING_TAG);
                sb.append(EVENTS_PARENT_CLOSING_TAG);
            }
        }
        sinkListener.publish((Object)sb.toString());
    }

    private String getClosingElement(String enclosingElement) {
        String[] results = enclosingElement.split(" ");
        if (results.length == 1) {
            StringBuilder builder = new StringBuilder(enclosingElement);
            builder.insert(1, "/");
            return builder.toString();
        }
        StringBuilder builder = new StringBuilder(results[0]);
        builder.append(">");
        builder.insert(1, "/");
        return builder.toString();
    }

    private String constructDefaultMapping(Event event) {
        StringBuilder builder = new StringBuilder(EVENT_PARENT_OPENING_TAG);
        Object[] data = event.getData();
        for (int i = 0; i < data.length; ++i) {
            String attributeName = this.streamDefinition.getAttributeNameArray()[i];
            builder.append("<").append(attributeName).append(">");
            if (data[i] != null) {
                builder.append(data[i].toString()).append("</").append(attributeName).append(">");
                continue;
            }
            builder.insert(builder.toString().length() - 1, NS_XSI_NIL_ENABLE);
        }
        builder.append(EVENT_PARENT_CLOSING_TAG);
        return builder.toString();
    }
}

