/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.map.xml.sourcemapper;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.core.exception.MappingFailedException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.stream.input.source.AttributeMapping;
import io.siddhi.core.stream.input.source.InputEventHandler;
import io.siddhi.core.stream.input.source.SourceMapper;
import io.siddhi.core.util.AttributeConverter;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.error.handler.model.ErroneousEvent;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.DeferredParsingException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jaxen.JaxenException;

@Extension(name="xml", namespace="sourceMapper", description="This mapper converts XML input to Siddhi event. Transports which accepts XML messages can utilize this extension to convert the incoming XML message to Siddhi event. Users can either send a pre-defined XML format where event conversion will happen without any configs or can use xpath to map from a custom XML message.", parameters={@Parameter(name="namespaces", description="Used to provide namespaces used in the incoming XML message beforehand to configure xpath expressions. User can provide a comma separated list. If these are not provided xpath evaluations will fail", type={DataType.STRING}, optional=true, defaultValue="None"), @Parameter(name="enclosing.element", description="Used when custom mapping is enabled to specify the XPath in case of sending multiple events (if XPath consist of multiple elements, or consists of child elements.) using the same XML content or when the event is not in root node.\nXML mapper will treat the child element/s of given enclosing element as event/s, when `enclosing.element.as.event` is set to `false`, and execute xpath expressions available in the attribute mappings on child elements.\n If enclosing.element is not provided XPaths in the attribute mappings will be evaluated with respect to root element.\nWhen enclosing element is used and custom mapping is enabled, the attribute mapping XPaths should be relative to child elements", type={DataType.STRING}, optional=true, defaultValue="Root element"), @Parameter(name="enclosing.element.as.event", description="This can either have value true or false. XML mapper will treat the child element/s of given enclosing element as event/s, when `enclosing.element.as.event` is set to `false`, and attribute mapping should be defined with with respect to the Xpath element's child elements.\n When `enclosing.element.as.event` is set to `true`, the elements (NOT child elements) retrieved from XPath itself will be treated as the event/s and attribute mapping should be defined with with respect to the Xpath element.\nWhen `enable.streaming.xml` is set to `true` the `enclosing.element.as.event` value will be set to `true` by default", type={DataType.BOOL}, optional=true, defaultValue="False"), @Parameter(name="fail.on.missing.attribute", description="This can either have value true or false. By default it will be true. This attribute allows user to handle unknown attributes. By default if an xpath execution fails or returns null DAS will drop that message. However setting this property to false will prompt DAS to send and event with null value to Siddhi where user can handle it accordingly(ie. Assign a default value)", type={DataType.BOOL}, optional=true, defaultValue="True"), @Parameter(name="enable.streaming.xml.content", description="This will be used when the XML content is streamed without sending the XML element/ event as a whole. eg: When streaming XML file line by line.", type={DataType.BOOL}, optional=true, defaultValue="false"), @Parameter(name="extract.leaf.node.data", description="This parameter will enable the event to contain the child element values.\nThis can be used when the given XPath node contains several child elements and also when the child elements have child elements as well.\nIf there are multiple child elements, the event count for one node will get multiplied by the number of child nodes.", type={DataType.BOOL}, optional=true, defaultValue="false")}, examples={@Example(syntax="@source(type='inMemory', topic='stock', @map(type='xml'))\ndefine stream FooStream (symbol string, price float, volume long);\n", description="Above configuration will do a default XML input mapping. Expected input will look like below.<events>\n    <event>\n        <symbol>WSO2</symbol>\n        <price>55.6</price>\n        <volume>100</volume>\n    </event>\n</events>\n"), @Example(syntax="@map(type='xml', enclosing.element=\"/events/wrapper/event\", \n     enclosing.element.as.event=\"true\", \n     @attributes(volume = \"volume\", price = \"price\", symbol = \"symbol\"))\ndefine stream FooStream (symbol string, price float, volume long);\n", description="Above configuration will do a custom mapping and and get the <event> element as a whole event in the given XPath. The attribute mapping has to be done with respect to the element mapped in the XPath. Expected input will look like below<events><wrapper>\n    <event>\n        <symbol>WSO2</symbol>\n        <price>55.6</price>\n        <volume>100</volume>\n    </event>\n    <event>\n        <symbol>WSO2</symbol>\n        <price>55.6</price>\n        <volume>100</volume>\n    </event>\n</wrapper></events>\n"), @Example(syntax="@map(type='xml', enclosing.element='/events/event',\n      @attributes(symbol='symbol', price='price', volume='volume'))\ndefine stream FooStream (symbol string, price float, volume long);\n", description="Above configuration will do a custom mapping and and get the <event> element as a whole event in the given XPath. The attribute mapping has to be done with respect to the element mapped in the XPath. Expected input will look like below.<events>\n    <event>\n        <symbol>WSO2</symbol>\n        <price>55.6</price>\n        <volume>100</volume>\n    </event>\n</events>\n"), @Example(syntax="@source(type='inMemory', topic='stock', \n  @map(type='xml', namespaces = \"dt=urn:schemas-microsoft-com:datatypes\", \n       enclosing.element=\"//portfolio\", \n       @attributes(symbol = \"company/symbol\", price = \"price\", \n                   volume = \"volume\")))\ndefine stream FooStream (symbol string, price float, volume long);", description="Above configuration will perform a custom XML mapping. In the custom mapping user can add xpath expressions representing each event attribute using @attribute annotation. Expected input will look like below.\n<portfolio xmlns:dt=\"urn:schemas-microsoft-com:datatypes\">\n    <stock exchange=\"nasdaq\">\n        <volume>100</volume>\n        <company>\n           <symbol>WSO2</symbol>\n        </company>\n        <price dt:type=\"number\">55.6</price>\n    </stock>\n</portfolio>"), @Example(syntax="@map(type='xml', \n      enclosing.element=\"/root/child\",\n      enable.streaming.xml.content=\"true\",\n      enclosing.element.as.event=\"true\",\n      extract.leaf.node.data=\"true\",\n      fail.on.missing.attribute=\"false\",\n      @attributes(id = \"/child/@id\", timestamp = \"/child/@timestamp\", \n                  key = \"/child/detail/@key\", \n                  value = \"/child/detail/@value\"))\ndefine stream FooStream (id string, timestamp string, key string, value string);\n", description="Above configuration will do a custom mapping and and get the <child> element as a whole event in the given XPath when the XML content received in a steaming manner (eg: when a file is read line by line and sent to the XML mapper to map).\nThe attribute mapping has to be done with respect to the element mapped in the XPath which is <child>\nIn here, the leaf node data is mapped to the <child> event as well. \nExpected input will look like below.\n<root>\n   <bounds minlat=\"53.4281\" minlon=\"-2.4142\" maxlat=\"54.0097\" maxlon=\"-0.9762\"/>\n   <child id=\"413229\" timestamp=\"2014-09-10T14:12:48Z\"/>\n   <child id=\"414427\" timestamp=\"2018-01-24T23:16:10Z\"/>\n   <child id=\"673959\" timestamp=\"2019-10-20T12:07:13Z\">\n       <extra id=\"1234\" timestamp=\"2014-09-11T10:36:37Z\"/>\n       <detail key=\"company\" value=\"wso2\"/>\n       <extra id=\"0987\" timestamp=\"2014-09-11T10:36:37Z\"/>\n       <detail key=\"country\" value=\"Sri Lanka\"/>\n   </child>\n   .\n   .\n</root>\n"), @Example(syntax="@map(type='xml', \n      enclosing.element=\"/root/child\",\n      enable.streaming.xml.content=\"true\",\n      enclosing.element.as.event=\"true\",\n      fail.on.missing.attribute=\"false\",\n      @attributes(id = \"/child/@id\", timestamp = \"/child/@timestamp\"))\ndefine stream FooStream (id string, timestamp string, key string, value string);\n", description="Above configuration will do a custom mapping and and get the <child> element as a whole event in the given XPath when the XML content received in a steaming manner (eg: when a file is read line by line and sent to the XML mapper to map).\nThe attribute mapping has to be done with respect to the element mapped in the XPath which is <child>\nExpected input will look like below.\n<root>\n   <bounds minlat=\"53.4281\" minlon=\"-2.4142\" maxlat=\"54.0097\" maxlon=\"-0.9762\"/>\n   <child id=\"413229\" timestamp=\"2014-09-10T14:12:48Z\"/>\n   <child id=\"414427\" timestamp=\"2018-01-24T23:16:10Z\"/>\n   <child id=\"673959\" timestamp=\"2019-10-20T12:07:13Z\">\n       <extra id=\"1234\" timestamp=\"2014-09-11T10:36:37Z\"/>\n       <detail key=\"company\" value=\"wso2\"/>\n       <extra id=\"0987\" timestamp=\"2014-09-11T10:36:37Z\"/>\n       <detail key=\"country\" value=\"Sri Lanka\"/>\n   </child>\n   .\n   .\n</root>\n")})
public class XmlSourceMapper
extends SourceMapper {
    private static final Logger log = LogManager.getLogger(XmlSourceMapper.class);
    private static final String PARENT_SELECTOR_XPATH = "enclosing.element";
    private static final String NAMESPACES = "namespaces";
    private static final String EVENTS_PARENT_ELEMENT = "events";
    private static final String EVENT_ELEMENT = "event";
    private static final String FAIL_ON_UNKNOWN_ATTRIBUTE = "fail.on.missing.attribute";
    private static final String ENCLOSING_ELEMENT_AS_EVENT = "enclosing.element.as.event";
    private static final String ENABLE_STREAMING_XML_CONTENT = "enable.streaming.xml.content";
    private static final String EXTRACT_LEAF_NODE_DATA = "extract.leaf.node.data";
    private boolean isCustomMappingEnabled = false;
    private StreamDefinition streamDefinition;
    private AXIOMXPath enclosingElementSelectorPath = null;
    private Map<String, String> namespaceMap;
    private Map<String, AXIOMXPath> xPathMap = new HashMap<String, AXIOMXPath>();
    private boolean failOnUnknownAttribute;
    private AttributeConverter attributeConverter = new AttributeConverter();
    private List<Attribute> attributeList;
    private Map<String, Attribute.Type> attributeTypeMap = new HashMap<String, Attribute.Type>();
    private Map<String, Integer> attributePositionMap = new HashMap<String, Integer>();
    private List<AttributeMapping> attributeMappingList;
    private boolean enclosingElementAsEvent = false;
    private String startNodeChunkingElement;
    private String endNodeChunkingElement;
    private StringBuilder xmlBuilder;
    private String eventPayload = "";
    private boolean loopUntilEndNodeChunkingElement;
    private boolean startNodeFound;
    private boolean enableStreamingXMLContent;
    private List<String> xPathArray;
    private boolean extractLeafNodeData;
    private boolean xPathDetected;
    private int xPathArrayIndex;
    private Pattern nodeStartPattern;
    private boolean differentElementMatcherStarted;
    private int numberOfDifferentNodes;
    private boolean differentNodesDetected;

    /*
     * Exception decompiling
     */
    public void init(StreamDefinition streamDefinition, OptionHolder optionHolder, List<AttributeMapping> attributeMappingList, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Class[] getSupportedInputEventClasses() {
        return new Class[]{String.class, OMElement.class, byte[].class};
    }

    protected void mapAndProcess(Object eventObject, InputEventHandler inputEventHandler) throws MappingFailedException, InterruptedException {
        ArrayList<ErroneousEvent> failedEvents = new ArrayList<ErroneousEvent>(0);
        try {
            Event[] result = !this.enableStreamingXMLContent ? this.convertToEvents(eventObject, failedEvents) : this.convertXMLStreamToEvents(eventObject, failedEvents);
            if (result.length > 0) {
                inputEventHandler.sendEvents(result);
            }
        }
        catch (Throwable t) {
            log.error("Exception occurred when converting XML message to Siddhi Event", t);
            failedEvents.add(new ErroneousEvent(eventObject, t, "Exception occurred when converting XML message to Siddhi Event"));
        }
        if (!failedEvents.isEmpty()) {
            throw new MappingFailedException(failedEvents);
        }
    }

    protected boolean allowNullInTransportProperties() {
        return !this.failOnUnknownAttribute;
    }

    private Event[] convertToEvents(Object eventObject, List<ErroneousEvent> failedEvents) {
        OMElement rootOMElement;
        ArrayList<Event> eventList = new ArrayList<Event>();
        if (eventObject instanceof String) {
            try {
                rootOMElement = AXIOMUtil.stringToOM((String)((String)eventObject));
            }
            catch (XMLStreamException | DeferredParsingException e) {
                log.warn("Error parsing incoming XML event : " + eventObject + ". Reason: " + e.getMessage() + ". Hence dropping message chunk");
                failedEvents.add(new ErroneousEvent(eventObject, e, "Error parsing incoming XML event : " + eventObject + ". Reason: " + e.getMessage() + ". Hence dropping message chunk"));
                return new Event[0];
            }
        } else if (eventObject instanceof OMElement) {
            rootOMElement = (OMElement)eventObject;
        } else if (eventObject instanceof byte[]) {
            String events = null;
            try {
                events = new String((byte[])eventObject, StandardCharsets.UTF_8);
                rootOMElement = AXIOMUtil.stringToOM((String)events);
            }
            catch (XMLStreamException | DeferredParsingException e) {
                log.warn("Error parsing incoming XML event : " + events + ". Reason: " + e.getMessage() + ". Hence dropping message chunk");
                failedEvents.add(new ErroneousEvent(eventObject, e, "Error parsing incoming XML event : " + events + ". Reason: " + e.getMessage() + ". Hence dropping message chunk"));
                return new Event[0];
            }
        } else {
            log.warn("Event object is invalid. Expected String/OMElement or Byte Array, but found " + eventObject.getClass().getCanonicalName());
            failedEvents.add(new ErroneousEvent(eventObject, "Event object is invalid. Expected String/OMElement or Byte Array, but found " + eventObject.getClass().getCanonicalName()));
            return new Event[0];
        }
        if (this.isCustomMappingEnabled) {
            if (this.enclosingElementSelectorPath != null) {
                List enclosingNodeList;
                try {
                    enclosingNodeList = this.enclosingElementSelectorPath.selectNodes((Object)rootOMElement);
                    if (enclosingNodeList.size() == 0) {
                        log.warn("Provided enclosing element did not match any xml node. Hence dropping the event :" + rootOMElement.toString());
                        failedEvents.add(new ErroneousEvent(eventObject, "Provided enclosing element did not match any xml node. Hence dropping the event :" + rootOMElement.toString()));
                        return new Event[0];
                    }
                }
                catch (JaxenException e) {
                    failedEvents.add(new ErroneousEvent(eventObject, (Throwable)e, "Error occurred when selecting nodes from XPath: " + this.enclosingElementSelectorPath.toString()));
                    throw new SiddhiAppRuntimeException("Error occurred when selecting nodes from XPath: " + this.enclosingElementSelectorPath.toString(), (Throwable)e);
                }
                for (Object enclosingNode : enclosingNodeList) {
                    Iterator iterator = ((OMElement)enclosingNode).getChildElements();
                    if (this.enclosingElementAsEvent) {
                        this.buildEventWithOMElementAsEvent(eventList, failedEvents, (OMElement)enclosingNode);
                        continue;
                    }
                    while (iterator.hasNext()) {
                        this.buildEventWithOMElementAsEvent(eventList, failedEvents, (OMElement)iterator.next());
                    }
                }
            } else {
                this.buildEventWithOMElementAsEvent(eventList, failedEvents, rootOMElement);
            }
        } else if (EVENTS_PARENT_ELEMENT.equals(rootOMElement.getLocalName())) {
            Iterator iterator = rootOMElement.getChildrenWithName(QName.valueOf(EVENT_ELEMENT));
            while (iterator.hasNext()) {
                boolean isMalformedEvent = false;
                OMElement eventOMElement = (OMElement)iterator.next();
                Event event = new Event(this.attributeList.size());
                Object[] data = event.getData();
                Iterator eventIterator = eventOMElement.getChildElements();
                while (eventIterator.hasNext()) {
                    OMElement attrOMElement = (OMElement)eventIterator.next();
                    String attributeName = attrOMElement.getLocalName();
                    Attribute.Type type = this.attributeTypeMap.get(attributeName);
                    if (type != null) {
                        try {
                            data[this.attributePositionMap.get((Object)attributeName).intValue()] = this.attributeConverter.getPropertyValue(attrOMElement.getText(), type);
                            continue;
                        }
                        catch (SiddhiAppRuntimeException | NumberFormatException e) {
                            log.warn("Error occurred when extracting attribute value. Cause: " + e.getMessage() + ". Hence dropping the event: " + eventOMElement.toString());
                            failedEvents.add(new ErroneousEvent(eventObject, e, "Error occurred when extracting attribute value. Cause: " + e.getMessage() + ". Hence dropping the event: " + eventOMElement.toString()));
                            isMalformedEvent = true;
                            break;
                        }
                    }
                    log.warn("Attribute : " + attributeName + " was not found in given stream definition. Hence ignoring this attribute");
                }
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null || !this.failOnUnknownAttribute) continue;
                    log.warn("No attribute with name: " + this.streamDefinition.getAttributeNameArray()[i] + " found in input event: " + eventOMElement.toString() + ". Hence dropping the event.");
                    failedEvents.add(new ErroneousEvent(eventObject, "No attribute with name: " + this.streamDefinition.getAttributeNameArray()[i] + " found in input event: " + eventOMElement.toString() + ". Hence dropping the event."));
                    isMalformedEvent = true;
                }
                if (isMalformedEvent) continue;
                eventList.add(event);
            }
        } else {
            log.warn("Incoming XML message should adhere to pre-defined format when using default mapping. Root element name should be events. But found " + rootOMElement.getLocalName() + ". Hence dropping XML message : " + rootOMElement.toString());
            failedEvents.add(new ErroneousEvent(eventObject, "Incoming XML message should adhere to pre-defined format when using default mapping. Root element name should be events. But found " + rootOMElement.getLocalName() + ". Hence dropping XML message : " + rootOMElement.toString()));
        }
        return eventList.toArray(new Event[0]);
    }

    private Event[] convertXMLStreamToEvents(Object eventObject, List<ErroneousEvent> failedEvents) {
        ArrayList<Event> eventList = new ArrayList<Event>();
        String currentEventPayload = "";
        if (eventObject instanceof String) {
            currentEventPayload = (String)eventObject;
        } else if (eventObject instanceof byte[]) {
            currentEventPayload = new String((byte[])eventObject, StandardCharsets.UTF_8);
        } else {
            log.warn("Event object is invalid. Expected String Byte Array when using 'chunking.element', but found " + eventObject.getClass().getCanonicalName());
            failedEvents.add(new ErroneousEvent(eventObject, "Event object is invalid. Expected String/OMElement or Byte Array, but found " + eventObject.getClass().getCanonicalName()));
            return new Event[0];
        }
        this.eventPayload = this.eventPayload + currentEventPayload.trim().replaceAll("\n", "");
        while (!(this.xPathArray.size() == 0 || this.xPathDetected || this.differentElementMatcherStarted || this.eventPayload.isEmpty())) {
            String findingNode = "<" + this.xPathArray.get(this.xPathArrayIndex);
            int index = this.eventPayload.indexOf(findingNode);
            if (index == -1) {
                this.eventPayload = "";
            } else {
                while (index >= 0 && this.numberOfDifferentNodes == 0 && !this.eventPayload.isEmpty()) {
                    index = 0;
                    ++this.xPathArrayIndex;
                    if (this.xPathArrayIndex == this.xPathArray.size()) {
                        this.xPathDetected = true;
                        this.startNodeChunkingElement = "<" + this.xPathArray.get(this.xPathArrayIndex - 1);
                        this.eventPayload = this.eventPayload.trim();
                        break;
                    }
                    this.eventPayload = this.eventPayload.substring(this.eventPayload.indexOf(findingNode) + findingNode.length());
                    findingNode = "<" + this.xPathArray.get(this.xPathArrayIndex);
                    String endingNode = "</" + this.xPathArray.get(this.xPathArrayIndex - 1);
                    if (this.eventPayload.contains(findingNode)) {
                        int xPathElementIndex = this.eventPayload.indexOf(findingNode);
                        int nextElementIndex = this.eventPayload.indexOf("<");
                        if (xPathElementIndex != -1 && nextElementIndex != -1 && xPathElementIndex <= nextElementIndex) {
                            index = this.eventPayload.indexOf(findingNode);
                            this.eventPayload = this.eventPayload.substring(this.eventPayload.indexOf(findingNode));
                            continue;
                        }
                        this.differentNodesDetected = true;
                        continue;
                    }
                    if (this.eventPayload.contains(endingNode)) {
                        this.eventPayload = "";
                        --this.xPathArrayIndex;
                        continue;
                    }
                    this.eventPayload = "";
                }
                while (this.differentNodesDetected && !this.differentElementMatcherStarted) {
                    String node;
                    Matcher matcher = this.nodeStartPattern.matcher(this.eventPayload);
                    if (!matcher.find()) continue;
                    this.differentElementMatcherStarted = true;
                    this.startNodeChunkingElement = node = matcher.group();
                    this.eventPayload = this.eventPayload.substring(this.eventPayload.indexOf(node) + node.length());
                }
            }
            if (this.xPathDetected) {
                this.buildAndSetOMElementToList(eventList, failedEvents, false);
                continue;
            }
            if (!this.differentElementMatcherStarted) continue;
            this.buildAndSetOMElementToList(null, null, true);
        }
        if (this.xPathDetected) {
            this.buildAndSetOMElementToList(eventList, failedEvents, false);
        } else if (this.differentElementMatcherStarted) {
            this.buildAndSetOMElementToList(null, null, true);
        }
        return eventList.toArray(new Event[0]);
    }

    private void buildEventWithOMElementAsEvent(List<Event> eventList, List<ErroneousEvent> failedEvents, OMElement enclosingNode) {
        if (this.enableStreamingXMLContent) {
            this.xPathDetected = false;
            --this.xPathArrayIndex;
            this.startNodeFound = false;
            this.differentElementMatcherStarted = false;
            this.differentNodesDetected = false;
        }
        try {
            if (!this.extractLeafNodeData) {
                Event event = this.buildEvent(enclosingNode);
                eventList.add(event);
            } else {
                this.buildEventIncludingLeafNodeValues(enclosingNode, eventList);
            }
        }
        catch (MappingFailedException e) {
            failedEvents.add(new ErroneousEvent((Object)enclosingNode, e.getMessage()));
        }
    }

    private void buildNamespaceMap(String namespace) {
        String[] namespaces;
        for (String ns : namespaces = namespace.split(",")) {
            String[] splits = ns.split("=");
            if (splits.length != 2) {
                log.warn("Malformed namespace mapping found: " + ns + ". Each namespace has to have format: <prefix>=<uri>");
            }
            this.namespaceMap.put(splits[0].trim(), splits[1].trim());
        }
    }

    private void buildEventIncludingLeafNodeValues(OMElement omElement, List<Event> eventList) throws MappingFailedException {
        if (omElement != null) {
            ArrayList<ValueHolder> leafNodeList = new ArrayList<ValueHolder>();
            this.iterateAndFindLeafNode("", omElement, null, leafNodeList);
            for (int i = 0; i < leafNodeList.size(); ++i) {
                ValueHolder node = (ValueHolder)leafNodeList.get(i);
                HashMap<String, String> convertedFlatEvent = new HashMap<String, String>();
                do {
                    Map<String, String> attributeMap = node.getAttributeMap();
                    for (Map.Entry<String, String> attributeEntry : attributeMap.entrySet()) {
                        convertedFlatEvent.put(attributeEntry.getKey(), attributeEntry.getValue());
                    }
                    Map<String, String> textValueMap = node.getTextValueMap();
                    for (Map.Entry<String, String> textValueEntry : textValueMap.entrySet()) {
                        convertedFlatEvent.put(textValueEntry.getKey(), textValueEntry.getValue());
                    }
                } while ((node = node.getPrevValueHolder()) != null);
                Event siddhiEvent = new Event(this.streamDefinition.getAttributeList().size());
                Object[] data = siddhiEvent.getData();
                for (AttributeMapping attributeMapping : this.attributeMappingList) {
                    String attributeName = attributeMapping.getName();
                    Attribute.Type attributeType = this.attributeTypeMap.get(attributeName);
                    String attributeValue = (String)convertedFlatEvent.get(this.xPathMap.get(attributeName).toString());
                    if (attributeValue != null || !this.failOnUnknownAttribute) {
                        if (attributeType.equals((Object)Attribute.Type.STRING)) {
                            data[attributeMapping.getPosition()] = attributeValue;
                            continue;
                        }
                        try {
                            data[attributeMapping.getPosition()] = this.attributeConverter.getPropertyValue(attributeValue, attributeType);
                            continue;
                        }
                        catch (SiddhiAppRuntimeException | NumberFormatException e) {
                            if (!this.failOnUnknownAttribute) continue;
                            String errMsg = "Error occurred when extracting attribute value. Cause: " + e.getMessage() + ". Hence dropping the event: " + omElement.toString();
                            log.warn(errMsg);
                            throw new MappingFailedException(errMsg);
                        }
                    }
                    String errMsg = "Error occurred when selecting attribute: " + attributeName + " in the input event, using the given XPath: " + this.xPathMap.get(attributeName).toString();
                    log.warn(errMsg);
                    throw new MappingFailedException(errMsg);
                }
                eventList.add(siddhiEvent);
            }
        }
    }

    private Event buildEvent(OMElement eventOMElement) throws MappingFailedException {
        Event event = new Event(this.streamDefinition.getAttributeList().size());
        Object[] data = event.getData();
        for (AttributeMapping attributeMapping : this.attributeMappingList) {
            String errMsg;
            String attributeName = attributeMapping.getName();
            Attribute.Type attributeType = this.attributeTypeMap.get(attributeName);
            AXIOMXPath axiomXPath = this.xPathMap.get(attributeName);
            boolean getRootNode = false;
            if (axiomXPath == null) continue;
            try {
                Object elementObj;
                List selectedNodes = axiomXPath.selectNodes((Object)eventOMElement);
                if (selectedNodes.size() == 0) {
                    if (this.enclosingElementAsEvent && eventOMElement.getLocalName().equalsIgnoreCase(axiomXPath.toString()) && eventOMElement.getFirstElement() == null) {
                        getRootNode = true;
                    } else {
                        if (!this.failOnUnknownAttribute) continue;
                        errMsg = "Xpath: '" + axiomXPath.toString() + " did not yield any results. Hence dropping the event : " + eventOMElement.toString();
                        log.warn(errMsg);
                        throw new MappingFailedException(errMsg);
                    }
                }
                if ((elementObj = getRootNode ? eventOMElement : selectedNodes.get(0)) instanceof OMElement) {
                    Object element = elementObj;
                    if (element.getFirstElement() != null) {
                        if (attributeType.equals((Object)Attribute.Type.STRING)) {
                            data[attributeMapping.getPosition()] = element.toString();
                            continue;
                        }
                        String errMsg2 = "XPath: " + axiomXPath.toString() + " did not return a leaf element and stream definition is not expecting a String attribute. Hence dropping the event: " + eventOMElement.toString();
                        log.warn(errMsg2);
                        throw new MappingFailedException(errMsg2);
                    }
                    String attributeValue = element.getText();
                    try {
                        data[attributeMapping.getPosition()] = this.attributeConverter.getPropertyValue(attributeValue, attributeType);
                        continue;
                    }
                    catch (SiddhiAppRuntimeException | NumberFormatException e) {
                        if (!this.failOnUnknownAttribute) continue;
                        String errMsg3 = "Error occurred when extracting attribute value. Cause: " + e.getMessage() + ". Hence dropping the event: " + eventOMElement.toString();
                        log.warn(errMsg3);
                        throw new MappingFailedException(errMsg3);
                    }
                }
                if (!(elementObj instanceof OMAttribute)) continue;
                OMAttribute omAttribute = (OMAttribute)elementObj;
                try {
                    data[attributeMapping.getPosition()] = this.attributeConverter.getPropertyValue(omAttribute.getAttributeValue(), attributeType);
                }
                catch (SiddhiAppRuntimeException | NumberFormatException e) {
                    String errMsg4 = "Error occurred when extracting attribute value. Cause: " + e.getMessage() + ". Hence dropping the event: " + eventOMElement.toString();
                    log.warn(errMsg4);
                    throw new MappingFailedException(errMsg4);
                }
            }
            catch (JaxenException e) {
                errMsg = "Error occurred when selecting attribute: " + attributeName + " in the input event, using the given XPath: " + this.xPathMap.get(attributeName).toString();
                log.warn(errMsg);
                throw new MappingFailedException(errMsg);
            }
        }
        return event;
    }

    private void buildAndSetOMElementToList(List<Event> eventList, List<ErroneousEvent> failedEvents, boolean iterateAndIgnore) {
        if (this.startNodeFound || this.eventPayload.indexOf(this.startNodeChunkingElement) == 0) {
            if (!this.startNodeFound && this.xmlBuilder.length() == 0) {
                this.xmlBuilder.append(this.startNodeChunkingElement);
                this.eventPayload = this.eventPayload.substring(this.eventPayload.indexOf(this.startNodeChunkingElement) + this.startNodeChunkingElement.length());
                this.startNodeFound = true;
            }
            if (!this.loopUntilEndNodeChunkingElement && this.eventPayload.contains("/>") && this.eventPayload.contains("<") && this.eventPayload.indexOf("/>") < this.eventPayload.indexOf("<")) {
                this.xmlBuilder.append(this.eventPayload, 0, this.eventPayload.indexOf("/>") + 2);
                this.eventPayload = this.eventPayload.substring(this.eventPayload.indexOf("/>") + 2);
                try {
                    if (!iterateAndIgnore) {
                        this.buildEventWithOMElementAsEvent(eventList, failedEvents, AXIOMUtil.stringToOM((String)this.xmlBuilder.toString()));
                    }
                }
                catch (XMLStreamException e) {
                    log.warn("Error parsing incoming XML event : " + this.xmlBuilder.toString() + ". Reason: " + e.getMessage() + ". Hence dropping message chunk");
                    failedEvents.add(new ErroneousEvent((Object)this.xmlBuilder.toString(), (Throwable)e, "Error parsing incoming XML event : " + this.xmlBuilder.toString() + ". Reason: " + e.getMessage() + ". Hence dropping message chunk"));
                }
                this.xmlBuilder = new StringBuilder();
            } else if (!this.loopUntilEndNodeChunkingElement && this.eventPayload.contains("/>") && !this.eventPayload.contains("<")) {
                this.xmlBuilder.append(this.eventPayload, 0, this.eventPayload.indexOf("/>") + 2);
                this.eventPayload = this.eventPayload.substring(this.eventPayload.indexOf("/>") + 2);
                try {
                    if (!iterateAndIgnore) {
                        this.buildEventWithOMElementAsEvent(eventList, failedEvents, AXIOMUtil.stringToOM((String)this.xmlBuilder.toString()));
                    }
                }
                catch (XMLStreamException e) {
                    log.warn("Error parsing incoming XML event : " + this.xmlBuilder.toString() + ". Reason: " + e.getMessage() + ". Hence dropping message chunk");
                    failedEvents.add(new ErroneousEvent((Object)this.xmlBuilder.toString(), (Throwable)e, "Error parsing incoming XML event : " + this.xmlBuilder.toString() + ". Reason: " + e.getMessage() + ". Hence dropping message chunk"));
                }
                this.xmlBuilder = new StringBuilder();
            } else if (!this.loopUntilEndNodeChunkingElement && !this.eventPayload.contains("/>") && this.eventPayload.contains(">") && this.eventPayload.contains("<") && this.eventPayload.indexOf(">") < this.eventPayload.indexOf("<")) {
                this.loopUntilEndNodeChunkingElement = true;
            } else if (!this.loopUntilEndNodeChunkingElement && !this.eventPayload.contains("/>") && this.eventPayload.contains(">")) {
                this.loopUntilEndNodeChunkingElement = true;
            }
            if (this.loopUntilEndNodeChunkingElement && this.eventPayload.contains(this.endNodeChunkingElement)) {
                this.xmlBuilder.append(this.eventPayload, 0, this.eventPayload.indexOf(this.endNodeChunkingElement) + this.endNodeChunkingElement.length());
                this.eventPayload = this.eventPayload.substring(this.eventPayload.indexOf(this.endNodeChunkingElement) + this.endNodeChunkingElement.length());
                try {
                    if (!iterateAndIgnore) {
                        this.buildEventWithOMElementAsEvent(eventList, failedEvents, AXIOMUtil.stringToOM((String)this.xmlBuilder.toString()));
                    }
                }
                catch (XMLStreamException e) {
                    log.warn("Error parsing incoming XML event : " + this.xmlBuilder.toString() + ". Reason: " + e.getMessage() + ". Hence dropping message chunk");
                    failedEvents.add(new ErroneousEvent((Object)this.xmlBuilder.toString(), (Throwable)e, "Error parsing incoming XML event : " + this.xmlBuilder.toString() + ". Reason: " + e.getMessage() + ". Hence dropping message chunk"));
                }
                this.loopUntilEndNodeChunkingElement = false;
                this.xmlBuilder = new StringBuilder();
            }
        }
    }

    private void iterateAndFindLeafNode(String currentPath, OMElement currentNode, ValueHolder parentValueHolder, List<ValueHolder> leafNodeList) {
        String nextPath;
        ValueHolder valueHolder = parentValueHolder == null ? new ValueHolder() : new ValueHolder(parentValueHolder);
        Iterator attributeIterator = currentNode.getAllAttributes();
        while (attributeIterator.hasNext()) {
            OMAttribute omAttribute = (OMAttribute)attributeIterator.next();
            valueHolder.getAttributeMap().put(currentPath + "/" + currentNode.getLocalName() + "/@" + omAttribute.getLocalName(), omAttribute.getAttributeValue());
        }
        Iterator eventIterator = currentNode.getChildElements();
        String string = nextPath = currentPath.isEmpty() ? "/" + currentNode.getLocalName() : currentPath + "/" + currentNode.getLocalName();
        if (eventIterator.hasNext()) {
            boolean valueHolderHasChildren = false;
            while (eventIterator.hasNext()) {
                OMElement omElement = (OMElement)eventIterator.next();
                if (omElement.getFirstElement() == null && !omElement.getText().trim().isEmpty()) {
                    valueHolder.getTextValueMap().put(nextPath + "/" + omElement.getLocalName(), omElement.getText().trim());
                    continue;
                }
                valueHolderHasChildren = true;
                this.iterateAndFindLeafNode(nextPath, omElement, valueHolder, leafNodeList);
            }
            if (!valueHolderHasChildren) {
                leafNodeList.add(valueHolder);
            }
        } else {
            leafNodeList.add(valueHolder);
        }
    }

    private static class ValueHolder {
        private ValueHolder prevValueHolder;
        private Map<String, String> attributeMap;
        private Map<String, String> textValueMap;

        public ValueHolder(ValueHolder prevValueHolder) {
            this.prevValueHolder = prevValueHolder;
            this.attributeMap = new HashMap<String, String>();
            this.textValueMap = new HashMap<String, String>();
        }

        public ValueHolder() {
            this.attributeMap = new HashMap<String, String>();
            this.textValueMap = new HashMap<String, String>();
        }

        public Map<String, String> getAttributeMap() {
            return this.attributeMap;
        }

        public ValueHolder getPrevValueHolder() {
            return this.prevValueHolder;
        }

        public Map<String, String> getTextValueMap() {
            return this.textValueMap;
        }
    }
}

