/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.store.mongodb;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import io.siddhi.core.table.record.RecordIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bson.Document;

public class MongoIterator
implements RecordIterator<Object[]> {
    private MongoCursor documents;
    private List<String> attributeNames;
    private boolean preFetched;
    private Object[] nextDocument;

    public MongoIterator(FindIterable documents, List<String> attributeNames) {
        this.documents = documents.iterator();
        this.attributeNames = attributeNames;
    }

    public boolean hasNext() {
        if (!this.preFetched) {
            this.nextDocument = this.next();
            this.preFetched = true;
        }
        return this.nextDocument.length != 0;
    }

    public Object[] next() {
        if (this.preFetched) {
            this.preFetched = false;
            Object[] result = this.nextDocument;
            this.nextDocument = null;
            return result;
        }
        if (this.documents.hasNext()) {
            return this.extractRecord((Document)this.documents.next());
        }
        return new Object[0];
    }

    private Object[] extractRecord(Document document) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String attributeName : this.attributeNames) {
            Object attributeValue = document.get(attributeName);
            if (attributeValue instanceof Document) {
                HashMap attributAsAMap = new HashMap();
                ((Document)attributeValue).forEach(attributAsAMap::put);
                result.add(attributAsAMap);
                continue;
            }
            result.add(attributeValue);
        }
        return result.toArray();
    }

    public void close() throws IOException {
    }
}

