/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.store.mongodb.util;

import com.mongodb.DBObject;
import com.mongodb.MongoClientOptions;
import com.mongodb.ReadConcern;
import com.mongodb.ReadConcernLevel;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.extension.store.mongodb.MongoCompiledCondition;
import io.siddhi.extension.store.mongodb.exception.MongoTableException;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.definition.Attribute;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.json.JsonParseException;

public class MongoTableUtils {
    private static final Log log = LogFactory.getLog(MongoTableUtils.class);

    private MongoTableUtils() {
    }

    public static IndexModel extractPrimaryKey(Annotation primaryKey, List<String> attributeNames) {
        if (primaryKey == null) {
            return null;
        }
        Document primaryKeyIndex = new Document();
        primaryKey.getElements().forEach(element -> {
            if (MongoTableUtils.isEmpty(element.getValue()) || !attributeNames.contains(element.getValue())) {
                throw new SiddhiAppCreationException("Annotation '" + primaryKey.getName() + "' contains value '" + element.getValue() + "' which is not present in the attributes of the Event Table.");
            }
            primaryKeyIndex.append(element.getValue(), 1);
        });
        return new IndexModel((Bson)primaryKeyIndex, new IndexOptions().unique(true));
    }

    public static List<IndexModel> extractIndexModels(Annotation indices, List<String> attributeNames) {
        if (indices == null) {
            return new ArrayList<IndexModel>();
        }
        Pattern indexBy = Pattern.compile("^(\\S*)(\\s1|\\s-1)?(\\s\\{.*})?$");
        return indices.getElements().stream().map(index -> {
            Matcher matcher = indexBy.matcher(index.getValue());
            if (matcher.matches() && attributeNames.contains(matcher.group(1))) {
                if (matcher.groupCount() == 4) {
                    return MongoTableUtils.createIndexModel(matcher.group(1), Integer.parseInt(matcher.group(2)), matcher.group(3).trim());
                }
                if (matcher.groupCount() == 3) {
                    if (matcher.group(3) == null) {
                        return MongoTableUtils.createIndexModel(matcher.group(1), Integer.parseInt(matcher.group(2).trim()), null);
                    }
                    return MongoTableUtils.createIndexModel(matcher.group(1), 1, matcher.group(3).trim());
                }
                return MongoTableUtils.createIndexModel(matcher.group(1), 1, null);
            }
            throw new SiddhiAppCreationException("Annotation '" + indices.getName() + "' contains illegal value : '" + index.getValue() + "'. Please check your query and try again.");
        }).collect(Collectors.toList());
    }

    private static IndexModel createIndexModel(String fieldName, Integer sortOrder, String indexOption) {
        Document indexDocument = new Document(fieldName, sortOrder);
        if (indexOption == null) {
            return new IndexModel((Bson)indexDocument);
        }
        IndexOptions indexOptions = new IndexOptions();
        try {
            Document indexOptionDocument = Document.parse(indexOption);
            block64: for (Map.Entry<String, Object> indexEntry : indexOptionDocument.entrySet()) {
                Object value = indexEntry.getValue();
                switch (indexEntry.getKey()) {
                    case "unique": {
                        indexOptions.unique(Boolean.parseBoolean(value.toString()));
                        continue block64;
                    }
                    case "background": {
                        indexOptions.background(Boolean.parseBoolean(value.toString()));
                        continue block64;
                    }
                    case "name": {
                        indexOptions.name(value.toString());
                        continue block64;
                    }
                    case "sparse": {
                        indexOptions.sparse(Boolean.parseBoolean(value.toString()));
                        continue block64;
                    }
                    case "expireAfterSeconds": {
                        indexOptions.expireAfter(Long.valueOf(Long.parseLong(value.toString())), TimeUnit.SECONDS);
                        continue block64;
                    }
                    case "version": {
                        indexOptions.version(Integer.valueOf(Integer.parseInt(value.toString())));
                        continue block64;
                    }
                    case "weights": {
                        indexOptions.weights((Bson)value);
                        continue block64;
                    }
                    case "languageOverride": {
                        indexOptions.languageOverride(value.toString());
                        continue block64;
                    }
                    case "defaultLanguage": {
                        indexOptions.defaultLanguage(value.toString());
                        continue block64;
                    }
                    case "textVersion": {
                        indexOptions.textVersion(Integer.valueOf(Integer.parseInt(value.toString())));
                        continue block64;
                    }
                    case "sphereVersion": {
                        indexOptions.sphereVersion(Integer.valueOf(Integer.parseInt(value.toString())));
                        continue block64;
                    }
                    case "bits": {
                        indexOptions.bits(Integer.valueOf(Integer.parseInt(value.toString())));
                        continue block64;
                    }
                    case "min": {
                        indexOptions.min(Double.valueOf(Double.parseDouble(value.toString())));
                        continue block64;
                    }
                    case "max": {
                        indexOptions.max(Double.valueOf(Double.parseDouble(value.toString())));
                        continue block64;
                    }
                    case "bucketSize": {
                        indexOptions.bucketSize(Double.valueOf(Double.parseDouble(value.toString())));
                        continue block64;
                    }
                    case "partialFilterExpression": {
                        indexOptions.partialFilterExpression((Bson)value);
                        continue block64;
                    }
                    case "collation": {
                        DBObject collationOptions = (DBObject)value;
                        Collation.Builder builder = Collation.builder();
                        block65: for (String collationKey : collationOptions.keySet()) {
                            String collationObj = value.toString();
                            switch (collationKey) {
                                case "locale": {
                                    builder.locale(collationObj);
                                    continue block65;
                                }
                                case "caseLevel": {
                                    builder.caseLevel(Boolean.valueOf(Boolean.parseBoolean(collationObj)));
                                    continue block65;
                                }
                                case "caseFirst": {
                                    builder.collationCaseFirst(CollationCaseFirst.fromString((String)collationObj));
                                    continue block65;
                                }
                                case "strength": {
                                    builder.collationStrength(CollationStrength.valueOf((String)collationObj));
                                    continue block65;
                                }
                                case "numericOrdering": {
                                    builder.numericOrdering(Boolean.valueOf(Boolean.parseBoolean(collationObj)));
                                    continue block65;
                                }
                                case "normalization": {
                                    builder.normalization(Boolean.valueOf(Boolean.parseBoolean(collationObj)));
                                    continue block65;
                                }
                                case "backwards": {
                                    builder.backwards(Boolean.valueOf(Boolean.parseBoolean(collationObj)));
                                    continue block65;
                                }
                                case "alternate": {
                                    builder.collationAlternate(CollationAlternate.fromString((String)collationObj));
                                    continue block65;
                                }
                                case "maxVariable": {
                                    builder.collationMaxVariable(CollationMaxVariable.fromString((String)collationObj));
                                    continue block65;
                                }
                            }
                            log.warn((Object)("Annotation 'IndexBy' for the field '" + fieldName + "' contains unknown 'Collation' Option key : '" + collationKey + "'. Please check your query and try again."));
                        }
                        if (builder.build().getLocale() != null) {
                            indexOptions.collation(builder.build());
                            continue block64;
                        }
                        throw new MongoTableException("Annotation 'IndexBy' for the field '" + fieldName + "' do not contain option for locale. Please check your query and try again.");
                    }
                    case "storageEngine": {
                        indexOptions.storageEngine((Bson)value);
                        continue block64;
                    }
                }
                log.warn((Object)("Annotation 'IndexBy' for the field '" + fieldName + "' contains unknown option key : '" + indexEntry.getKey() + "'. Please check your query and try again."));
            }
        }
        catch (NumberFormatException | JsonParseException e) {
            throw new MongoTableException("Annotation 'IndexBy' for the field '" + fieldName + "' contains illegal value(s) for index option. Please check your query and try again.", e);
        }
        return new IndexModel((Bson)indexDocument, indexOptions);
    }

    public static Document resolveCondition(MongoCompiledCondition compiledCondition, Map<String, Object> conditionParameterMap) {
        Map<String, Object> parameters = compiledCondition.getPlaceholders();
        String compiledQuery = compiledCondition.getCompiledQuery();
        if (compiledQuery.equalsIgnoreCase("true")) {
            return new Document();
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            Object parameter = entry.getValue();
            Attribute variable = (Attribute)parameter;
            if (variable.getType().equals((Object)Attribute.Type.STRING)) {
                compiledQuery = compiledQuery.replaceAll(entry.getKey(), "\"" + conditionParameterMap.get(variable.getName()).toString() + "\"");
                continue;
            }
            compiledQuery = compiledQuery.replaceAll(entry.getKey(), conditionParameterMap.get(variable.getName()).toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("The final compiled query : '" + compiledQuery + "'"));
        }
        return Document.parse(compiledQuery);
    }

    public static boolean isEmpty(String field) {
        return field == null || field.trim().length() == 0;
    }

    public static Map<String, Object> mapValuesToAttributes(Object[] record, List<String> attributeNames) {
        HashMap<String, Object> attributesValuesMap = new HashMap<String, Object>();
        for (int i = 0; i < record.length; ++i) {
            attributesValuesMap.put(attributeNames.get(i), record[i]);
        }
        return attributesValuesMap;
    }

    public static void checkExistingIndices(List<IndexModel> expectedIndices, MongoCursor<Document> existingIndices) {
        HashMap indexOptionsMap = new HashMap();
        List expectedIndexDocuments = expectedIndices.stream().map(expectedIndex -> {
            IndexOptions expectedIndexOptions = expectedIndex.getOptions();
            indexOptionsMap.put("key", expectedIndex.getKeys());
            if (expectedIndexOptions.getName() == null) {
                StringBuilder indexName = new StringBuilder();
                ((Document)expectedIndex.getKeys()).forEach((key, value) -> indexName.append("_").append((String)key).append("_").append(value));
                indexName.deleteCharAt(0);
                indexOptionsMap.put("name", indexName.toString());
            } else {
                indexOptionsMap.put("name", expectedIndexOptions.getName());
            }
            if (expectedIndexOptions.getVersion() == null) {
                indexOptionsMap.put("v", 2);
            } else {
                indexOptionsMap.put("v", expectedIndexOptions.getVersion());
            }
            indexOptionsMap.put("unique", expectedIndexOptions.isUnique());
            indexOptionsMap.put("background", expectedIndexOptions.isBackground());
            indexOptionsMap.put("sparse", expectedIndexOptions.isSparse());
            indexOptionsMap.put("expireAfterSeconds", expectedIndexOptions.getExpireAfter(TimeUnit.SECONDS));
            indexOptionsMap.put("weights", expectedIndexOptions.getWeights());
            indexOptionsMap.put("languageOverride", expectedIndexOptions.getLanguageOverride());
            indexOptionsMap.put("defaultLanguage", expectedIndexOptions.getDefaultLanguage());
            indexOptionsMap.put("textVersion", expectedIndexOptions.getTextVersion());
            indexOptionsMap.put("sphereVersion", expectedIndexOptions.getSphereVersion());
            indexOptionsMap.put("textVersion", expectedIndexOptions.getTextVersion());
            indexOptionsMap.put("bits", expectedIndexOptions.getBits());
            indexOptionsMap.put("min", expectedIndexOptions.getMin());
            indexOptionsMap.put("max", expectedIndexOptions.getMax());
            indexOptionsMap.put("bucketSize", expectedIndexOptions.getBucketSize());
            indexOptionsMap.put("partialFilterExpression", expectedIndexOptions.getPartialFilterExpression());
            indexOptionsMap.put("collation", expectedIndexOptions.getCollation());
            indexOptionsMap.put("storageEngine", expectedIndexOptions.getStorageEngine());
            indexOptionsMap.values().removeIf(Objects::isNull);
            indexOptionsMap.remove("unique", false);
            indexOptionsMap.remove("background", false);
            indexOptionsMap.remove("sparse", false);
            return new Document(indexOptionsMap);
        }).collect(Collectors.toList());
        ArrayList existingIndexDocuments = new ArrayList();
        existingIndices.forEachRemaining(existingIndex -> {
            existingIndex.remove("ns");
            existingIndexDocuments.add(existingIndex);
        });
        if (!existingIndexDocuments.containsAll(expectedIndexDocuments)) {
            log.warn((Object)("Existing indices differs from the expected indices defined by the Annotations 'PrimaryKey' and 'IndexBy'.\nExisting Indices '" + ((Object)existingIndexDocuments).toString() + "'.\nExpected Indices '" + expectedIndexDocuments.toString() + "'"));
        }
    }

    public static MongoClientOptions.Builder extractMongoClientOptionsBuilder(Annotation storeAnnotation, ConfigReader configReader) {
        MongoClientOptions.Builder mongoClientOptionsBuilder = MongoClientOptions.builder();
        try {
            String secureConnectionEnabled;
            String applicationName;
            String requiredReplicaSetName;
            int maxConnectionIdleTime;
            mongoClientOptionsBuilder.connectionsPerHost(Integer.parseInt(configReader.readConfig("connectionsPerHost", "100")));
            mongoClientOptionsBuilder.connectTimeout(Integer.parseInt(configReader.readConfig("connectTimeout", "10000")));
            mongoClientOptionsBuilder.heartbeatConnectTimeout(Integer.parseInt(configReader.readConfig("heartbeatConnectTimeout", "20000")));
            mongoClientOptionsBuilder.heartbeatSocketTimeout(Integer.parseInt(configReader.readConfig("heartbeatSocketTimeout", "20000")));
            mongoClientOptionsBuilder.heartbeatFrequency(Integer.parseInt(configReader.readConfig("heartbeatFrequency", "10000")));
            mongoClientOptionsBuilder.localThreshold(Integer.parseInt(configReader.readConfig("localThreshold", "15")));
            mongoClientOptionsBuilder.maxWaitTime(Integer.parseInt(configReader.readConfig("maxWaitTime", "120000")));
            mongoClientOptionsBuilder.minConnectionsPerHost(Integer.parseInt(configReader.readConfig("minConnectionsPerHost", "0")));
            mongoClientOptionsBuilder.minHeartbeatFrequency(Integer.parseInt(configReader.readConfig("minHeartbeatFrequency", "500")));
            mongoClientOptionsBuilder.serverSelectionTimeout(Integer.parseInt(configReader.readConfig("serverSelectionTimeout", "30000")));
            mongoClientOptionsBuilder.socketTimeout(Integer.parseInt(configReader.readConfig("socketTimeout", "0")));
            mongoClientOptionsBuilder.threadsAllowedToBlockForConnectionMultiplier(Integer.parseInt(configReader.readConfig("threadsAllowedToBlockForConnectionMultiplier", "5")));
            mongoClientOptionsBuilder.socketKeepAlive(Boolean.parseBoolean(configReader.readConfig("socketKeepAlive", "false")));
            mongoClientOptionsBuilder.sslEnabled(Boolean.parseBoolean(configReader.readConfig("sslEnabled", "false")));
            mongoClientOptionsBuilder.cursorFinalizerEnabled(Boolean.parseBoolean(configReader.readConfig("cursorFinalizerEnabled", "true")));
            mongoClientOptionsBuilder.readPreference(ReadPreference.valueOf((String)configReader.readConfig("readPreference", "primary")));
            mongoClientOptionsBuilder.writeConcern(WriteConcern.valueOf((String)configReader.readConfig("writeConcern", "acknowledged")));
            String readConcern = configReader.readConfig("readConcern", "DEFAULT");
            if (!readConcern.matches("DEFAULT")) {
                mongoClientOptionsBuilder.readConcern(new ReadConcern(ReadConcernLevel.fromString((String)readConcern)));
            }
            if ((maxConnectionIdleTime = Integer.parseInt(configReader.readConfig("maxConnectionIdleTime", "0"))) != 0) {
                mongoClientOptionsBuilder.maxConnectionIdleTime(maxConnectionIdleTime);
            }
            int maxConnectionLifeTime = Integer.parseInt(configReader.readConfig("maxConnectionLifeTime", "0"));
            if (maxConnectionIdleTime != 0) {
                mongoClientOptionsBuilder.maxConnectionLifeTime(maxConnectionLifeTime);
            }
            if (!(requiredReplicaSetName = configReader.readConfig("requiredReplicaSetName", "")).equals("")) {
                mongoClientOptionsBuilder.requiredReplicaSetName(requiredReplicaSetName);
            }
            if (!(applicationName = configReader.readConfig("applicationName", "")).equals("")) {
                mongoClientOptionsBuilder.applicationName(applicationName);
            }
            String string = secureConnectionEnabled = (secureConnectionEnabled = storeAnnotation.getElement("secure.connection")) == null ? "false" : secureConnectionEnabled;
            if (secureConnectionEnabled.equalsIgnoreCase("true")) {
                mongoClientOptionsBuilder.sslEnabled(true);
                String trustStore = storeAnnotation.getElement("trust.store");
                trustStore = trustStore == null ? configReader.readConfig("trustStore", "${carbon.home}/resources/security/client-truststore.jks") : trustStore;
                trustStore = MongoTableUtils.resolveCarbonHome(trustStore);
                String trustStorePassword = storeAnnotation.getElement("trust.store.password");
                trustStorePassword = trustStorePassword == null ? configReader.readConfig("trustStorePassword", "wso2carbon") : trustStorePassword;
                String keyStore = storeAnnotation.getElement("key.store");
                keyStore = keyStore == null ? configReader.readConfig("keyStore", "${carbon.home}/resources/security/client-truststore.jks") : keyStore;
                keyStore = MongoTableUtils.resolveCarbonHome(keyStore);
                String keyStorePassword = storeAnnotation.getElement("key.store.password");
                keyStorePassword = keyStorePassword == null ? configReader.readConfig("keyStorePassword", "wso2carbon") : keyStorePassword;
                mongoClientOptionsBuilder.socketFactory(MongoTableUtils.extractSocketFactory(trustStore, trustStorePassword, keyStore, keyStorePassword));
            }
            return mongoClientOptionsBuilder;
        }
        catch (IllegalArgumentException e) {
            throw new MongoTableException("Values Read from config readers have illegal values : ", e);
        }
    }

    private static SocketFactory extractSocketFactory(String trustStore, String trustStorePassword, String keyStore, String keyStorePassword) {
        KeyManager[] keyManagers;
        TrustManager[] trustManagers;
        Throwable throwable;
        try {
            throwable = null;
            try (FileInputStream trustStream = new FileInputStream(trustStore);){
                char[] trustStorePass = trustStorePassword.toCharArray();
                KeyStore trustStoreJKS = KeyStore.getInstance(KeyStore.getDefaultType());
                trustStoreJKS.load(trustStream, trustStorePass);
                TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustFactory.init(trustStoreJKS);
                trustManagers = trustFactory.getTrustManagers();
            }
            catch (Throwable trustStorePass) {
                throwable = trustStorePass;
                throw trustStorePass;
            }
        }
        catch (FileNotFoundException e) {
            throw new MongoTableException("Trust store file not found for secure connections to mongodb. Trust Store file path : '" + trustStore + "'.", e);
        }
        catch (IOException e) {
            throw new MongoTableException("I/O Exception in creating trust store for secure connections to mongodb. Trust Store file path : '" + trustStore + "'.", e);
        }
        catch (CertificateException e) {
            throw new MongoTableException("Certificates in the trust store could not be loaded for secure connections to mongodb. Trust Store file path : '" + trustStore + "'.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoTableException("The algorithm used to check the integrity of the trust store cannot be found. Trust Store file path : '" + trustStore + "'.", e);
        }
        catch (KeyStoreException e) {
            throw new MongoTableException("Exception in creating trust store, no Provider supports aKeyStoreSpi implementation for the specified type. Trust Store file path : '" + trustStore + "'.", e);
        }
        try {
            throwable = null;
            try (FileInputStream keyStream = new FileInputStream(keyStore);){
                char[] keyStorePass = keyStorePassword.toCharArray();
                KeyStore keyStoreJKS = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStoreJKS.load(keyStream, keyStorePass);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStoreJKS, keyStorePass);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException e) {
            throw new MongoTableException("Key store file not found for secure connections to mongodb. Key Store file path : '" + keyStore + "'.", e);
        }
        catch (IOException e) {
            throw new MongoTableException("I/O Exception in creating trust store for secure connections to mongodb. Key Store file path : '" + keyStore + "'.", e);
        }
        catch (CertificateException e) {
            throw new MongoTableException("Certificates in the trust store could not be loaded for secure connections to mongodb. Key Store file path : '" + keyStore + "'.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoTableException("The algorithm used to check the integrity of the trust store cannot be found. Key Store file path : '" + keyStore + "'.", e);
        }
        catch (KeyStoreException e) {
            throw new MongoTableException("Exception in creating trust store, no Provider supports aKeyStoreSpi implementation for the specified type. Key Store file path : '" + keyStore + "'.", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new MongoTableException("Key in the keystore cannot be recovered. Key Store file path : '" + keyStore + "'.", e);
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(keyManagers, trustManagers, null);
            SSLContext.setDefault(sslContext);
            return sslContext.getSocketFactory();
        }
        catch (KeyManagementException e) {
            throw new MongoTableException("Error in validating the key in the key store/ trust store. Trust Store file path : '" + trustStore + "'. Key Store file path : '" + keyStore + "'.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoTableException(" SSL Algorithm used to create SSL Socket Factory for mongodb connections is not found.", e);
        }
    }

    private static String resolveCarbonHome(String filePath) {
        String carbonHome = "";
        if (System.getProperty("carbon.home") != null) {
            carbonHome = System.getProperty("carbon.home");
        } else if (System.getenv("carbon.home") != null) {
            carbonHome = System.getenv("carbon.home");
        }
        return filePath.replaceAll("\\$\\{carbon.home}", carbonHome);
    }
}

