/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.store.mongodb;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import io.siddhi.core.table.record.RecordIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bson.Document;

public class MongoIterator
implements RecordIterator<Object[]> {
    private MongoCursor documents;
    private List<String> attributeNames;

    public MongoIterator(FindIterable documents, List<String> attributeNames) {
        this.documents = documents.iterator();
        this.attributeNames = attributeNames;
    }

    public MongoIterator(AggregateIterable documents, List<String> attributeNames) {
        this.documents = documents.iterator();
        this.attributeNames = attributeNames;
    }

    public boolean hasNext() {
        return this.documents.hasNext();
    }

    public Object[] next() {
        return this.extractRecord((Document)this.documents.next());
    }

    private Object[] extractRecord(Document document) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String attributeName : this.attributeNames) {
            Object attributeValue = document.get((Object)attributeName);
            if (attributeValue instanceof Document) {
                HashMap attributAsAMap = new HashMap();
                ((Document)attributeValue).forEach(attributAsAMap::put);
                result.add(attributAsAMap);
                continue;
            }
            result.add(attributeValue);
        }
        return result.toArray();
    }

    public void close() {
    }
}

