/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.store.mongodb;

import io.siddhi.core.table.record.BaseExpressionVisitor;
import io.siddhi.core.table.record.ExpressionVisitor;
import io.siddhi.extension.store.mongodb.exception.MongoTableException;
import io.siddhi.extension.store.mongodb.util.MongoTableUtils;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.expression.condition.Compare;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;

public class MongoSelectExpressionVisitor
extends BaseExpressionVisitor {
    private static int streamVarCount = 0;
    private Stack<String> conditionOperands;
    private Map<String, Object> placeholders;
    private String[] supportedFunctions = new String[]{"sum", "avg", "min", "max", "count"};
    private boolean isAttributeFunctionUsed = false;
    private boolean isCountFunction = false;
    private boolean isNullCheck = false;

    public MongoSelectExpressionVisitor() {
        this.conditionOperands = new Stack();
        this.placeholders = new HashMap<String, Object>();
    }

    public String getCompiledCondition() {
        return this.conditionOperands.pop();
    }

    public boolean isFunctionsPresent() {
        return this.isAttributeFunctionUsed;
    }

    public Map<String, Object> getPlaceholders() {
        return this.placeholders;
    }

    public void beginVisitConstant(Object value, Attribute.Type type) {
        String constantAttribute = "{'$literal':{{FIELD_NAME}}}".replace("{{FIELD_NAME}}", value.toString());
        this.conditionOperands.push(constantAttribute);
    }

    public void endVisitConstant(Object value, Attribute.Type type) {
    }

    public void beginVisitStoreVariable(String storeId, String attributeName, Attribute.Type type) {
        if (this.isCountFunction) {
            throw new MongoTableException("The MongoDB Event table does not support arguments in count function.");
        }
        String storeAttribute = "'${{FIELD_NAME}}'".replace("{{FIELD_NAME}}", attributeName);
        this.conditionOperands.push(storeAttribute);
    }

    public void endVisitStoreVariable(String storeId, String attributeName, Attribute.Type type) {
    }

    public void beginVisitStreamVariable(String id, String streamId, String attributeName, Attribute.Type type) {
        if (this.isCountFunction) {
            throw new MongoTableException("The MongoDB Event table does not support arguments in count function.");
        }
        if (this.isNullCheck) {
            throw new MongoTableException("The MongoDB Event table does not support 'is null' condition with stream variables.");
        }
        String name = this.generateStreamVarName();
        this.placeholders.put(name, new Attribute(id, type));
        String streamAttribute = "{'$literal':{{FIELD_NAME}}}".replace("{{FIELD_NAME}}", name);
        this.conditionOperands.push(streamAttribute);
    }

    public void endVisitStreamVariable(String id, String streamId, String attributeName, Attribute.Type type) {
    }

    public void beginVisitAttributeFunction(String namespace, String functionName) {
        if (!MongoTableUtils.isEmpty(namespace) || !Arrays.asList(this.supportedFunctions).contains(functionName)) {
            throw new MongoTableException("The MongoDB Event table does not support functions other than sum(), avg(), min(), max() and count().");
        }
        if (functionName.equalsIgnoreCase("count")) {
            this.isCountFunction = true;
        }
    }

    public void endVisitAttributeFunction(String namespace, String functionName) {
        if (MongoTableUtils.isEmpty(namespace) && Arrays.asList(this.supportedFunctions).contains(functionName)) {
            this.isAttributeFunctionUsed = true;
            if (functionName.equalsIgnoreCase("count")) {
                this.isCountFunction = false;
                this.conditionOperands.push("{$sum:1}");
            } else {
                String functionArgument = this.conditionOperands.pop();
                String functionFilter = "{${{FUNCTION_NAME}}:{{FUNCTION_ARGUMENT}}}".replace("{{FUNCTION_NAME}}", functionName).replace("{{FUNCTION_ARGUMENT}}", functionArgument);
                this.conditionOperands.push(functionFilter);
            }
        }
    }

    public void beginVisitParameterAttributeFunction(int index) {
    }

    public void endVisitParameterAttributeFunction(int index) {
    }

    public void beginVisitMath(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void endVisitMath(ExpressionVisitor.MathOperator mathOperator) {
        String rightOperand = this.conditionOperands.pop();
        String leftOperand = this.conditionOperands.pop();
        String mathOperatorName = mathOperator.name().toLowerCase(Locale.ENGLISH);
        String mathFilter = "{${{MATH_OPERATOR}}:[{{LEFT_OPERAND}},{{RIGHT_OPERAND}}]}".replace("{{MATH_OPERATOR}}", mathOperatorName).replace("{{LEFT_OPERAND}}", leftOperand).replace("{{RIGHT_OPERAND}}", rightOperand);
        this.conditionOperands.push(mathFilter);
    }

    public void beginVisitMathLeftOperand(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void endVisitMathLeftOperand(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void beginVisitMathRightOperand(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void endVisitMathRightOperand(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void beginVisitOr() {
    }

    public void endVisitOr() {
        String rightOperand = this.conditionOperands.pop();
        String leftOperand = this.conditionOperands.pop();
        String orFilter = "{$or:[{{LEFT_OPERAND}},{{RIGHT_OPERAND}}]}".replace("{{LEFT_OPERAND}}", leftOperand).replace("{{RIGHT_OPERAND}}", rightOperand);
        this.conditionOperands.push(orFilter);
    }

    public void beginVisitOrLeftOperand() {
    }

    public void endVisitOrLeftOperand() {
    }

    public void beginVisitOrRightOperand() {
    }

    public void endVisitOrRightOperand() {
    }

    public void beginVisitAnd() {
    }

    public void endVisitAnd() {
        String rightOperand = this.conditionOperands.pop();
        String leftOperand = this.conditionOperands.pop();
        String andFilter = "{$and:[{{LEFT_OPERAND}},{{RIGHT_OPERAND}}]}".replace("{{LEFT_OPERAND}}", leftOperand).replace("{{RIGHT_OPERAND}}", rightOperand);
        this.conditionOperands.push(andFilter);
    }

    public void beginVisitAndLeftOperand() {
    }

    public void endVisitAndLeftOperand() {
    }

    public void beginVisitAndRightOperand() {
    }

    public void endVisitAndRightOperand() {
    }

    public void beginVisitIsNull(String streamId) {
        this.isNullCheck = true;
    }

    public void endVisitIsNull(String streamId) {
        this.isNullCheck = false;
        String nullCheckAttribute = this.conditionOperands.pop();
        String compareOperator = "$eq";
        String compareFilter = "{$cond:{if:{{{COMPARE_OPERATOR}}:[{{LEFT_OPERAND}},{{RIGHT_OPERAND}}]},then:true,else:false}}".replace("{{COMPARE_OPERATOR}}", compareOperator).replace("{{LEFT_OPERAND}}", nullCheckAttribute).replace("{{RIGHT_OPERAND}}", "null");
        this.conditionOperands.push(compareFilter);
    }

    public void beginVisitCompare(Compare.Operator operator) {
    }

    public void endVisitCompare(Compare.Operator operator) {
        String compareOperator = MongoTableUtils.getCompareOperator(operator);
        String rightOperand = this.conditionOperands.pop();
        String leftOperand = this.conditionOperands.pop();
        String compareFilter = "{$cond:{if:{{{COMPARE_OPERATOR}}:[{{LEFT_OPERAND}},{{RIGHT_OPERAND}}]},then:true,else:false}}".replace("{{COMPARE_OPERATOR}}", compareOperator).replace("{{LEFT_OPERAND}}", leftOperand).replace("{{RIGHT_OPERAND}}", rightOperand);
        this.conditionOperands.push(compareFilter);
    }

    public void beginVisitCompareLeftOperand(Compare.Operator operator) {
    }

    public void endVisitCompareLeftOperand(Compare.Operator operator) {
    }

    public void beginVisitCompareRightOperand(Compare.Operator operator) {
    }

    public void endVisitCompareRightOperand(Compare.Operator operator) {
    }

    public void beginVisitNot() {
    }

    public void endVisitNot() {
        String conditionalFilter = this.conditionOperands.pop();
        String notFilter = "{{{FIELD_NAME}}:{{OPERAND}}}".replace("{{FIELD_NAME}}", "$not").replace("{{OPERAND}}", conditionalFilter);
        this.conditionOperands.push(notFilter);
    }

    public void beginVisitIn(String storeId) {
        throw new MongoTableException("MongoDB Event Table does not support 'IN' function.");
    }

    public void endVisitIn(String storeId) {
    }

    private String generateStreamVarName() {
        String name = "strVar" + streamVarCount;
        ++streamVarCount;
        return name;
    }
}

