/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.store.mongodb;

import io.siddhi.core.table.record.BaseExpressionVisitor;
import io.siddhi.core.table.record.ExpressionVisitor;
import io.siddhi.extension.store.mongodb.exception.MongoTableException;
import io.siddhi.extension.store.mongodb.util.Constant;
import io.siddhi.extension.store.mongodb.util.MongoTableUtils;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.expression.condition.Compare;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MongoExpressionVisitor
extends BaseExpressionVisitor {
    private Stack<String> conditionOperands = new Stack();
    private Map<String, Object> placeholders = new HashMap<String, Object>();
    private int streamVarCount = 0;
    private int constantCount = 0;
    private boolean isHavingClause;

    public MongoExpressionVisitor() {
        this.isHavingClause = false;
    }

    public MongoExpressionVisitor(boolean isHavingClause) {
        this.isHavingClause = isHavingClause;
    }

    public String getCompiledCondition() {
        String compiledCondition = this.conditionOperands.pop();
        for (Map.Entry<String, Object> entry : this.placeholders.entrySet()) {
            if (!(entry.getValue() instanceof Constant)) continue;
            Constant constant = (Constant)entry.getValue();
            if (constant.getType().equals((Object)Attribute.Type.STRING)) {
                compiledCondition = compiledCondition.replaceAll(entry.getKey(), "'" + constant.getValue().toString() + "'");
                continue;
            }
            compiledCondition = compiledCondition.replaceAll(entry.getKey(), constant.getValue().toString());
        }
        this.placeholders.values().removeIf(value -> value instanceof Constant);
        return compiledCondition;
    }

    public Map<String, Object> getPlaceholders() {
        return this.placeholders;
    }

    public Stack<String> getConditionOperands() {
        return this.conditionOperands;
    }

    public int getStreamVarCount() {
        return this.streamVarCount;
    }

    public int getConstantCount() {
        return this.constantCount;
    }

    public void beginVisitAnd() {
    }

    public void endVisitAnd() {
        String rightOperand = this.conditionOperands.pop();
        String leftOperand = this.conditionOperands.pop();
        if (!rightOperand.matches("\\{.*}$") || !leftOperand.matches("\\{.*}$")) {
            throw new MongoTableException("MongoDB Event Table found operands '" + leftOperand + "' and '" + rightOperand + "' for AND operation. Mongo Event table only supports AND operation between two expressions. Please check your query and try again.");
        }
        String andFilter = "{$and:[{{LEFT_OPERAND}},{{RIGHT_OPERAND}}]}".replace("{{LEFT_OPERAND}}", leftOperand).replace("{{RIGHT_OPERAND}}", rightOperand);
        this.conditionOperands.push(andFilter);
    }

    public void beginVisitAndLeftOperand() {
    }

    public void endVisitAndLeftOperand() {
    }

    public void beginVisitAndRightOperand() {
    }

    public void endVisitAndRightOperand() {
    }

    public void beginVisitOr() {
    }

    public void endVisitOr() {
        String rightOperand = this.conditionOperands.pop();
        String leftOperand = this.conditionOperands.pop();
        if (!rightOperand.matches("\\{.*}$") || !leftOperand.matches("\\{.*}$")) {
            throw new MongoTableException("MongoDB Event Table found operands '" + leftOperand + "' and '" + rightOperand + "' for OR operation.The Mongo Event table only supports OR operation between two expressions. Please check your query and try again.");
        }
        String orFilter = "{$or:[{{LEFT_OPERAND}},{{RIGHT_OPERAND}}]}".replace("{{LEFT_OPERAND}}", leftOperand).replace("{{RIGHT_OPERAND}}", rightOperand);
        this.conditionOperands.push(orFilter);
    }

    public void beginVisitOrLeftOperand() {
    }

    public void endVisitOrLeftOperand() {
    }

    public void beginVisitOrRightOperand() {
    }

    public void endVisitOrRightOperand() {
    }

    public void beginVisitNot() {
    }

    public void endVisitNot() {
        String operand = this.conditionOperands.pop();
        Pattern pattern = Pattern.compile("^\\{(\\S*):\\{.*}}$");
        Matcher matcher = pattern.matcher(operand);
        if (!matcher.find()) {
            throw new MongoTableException("MongoDB Event Table found operand '" + operand + "' for NOT operation. The Mongo Event table only supports NOT operation on simple expression such as compare and null check. Please check your query and try again.");
        }
        String fieldName = matcher.group(1);
        operand = operand.replace(fieldName, "$not");
        String notFilter = "{{{FIELD_NAME}}:{{OPERAND}}}".replace("{{FIELD_NAME}}", fieldName).replace("{{OPERAND}}", operand);
        this.conditionOperands.push(notFilter);
    }

    public void beginVisitCompare(Compare.Operator operator) {
    }

    public void endVisitCompare(Compare.Operator operator) {
        String rightOperand = this.conditionOperands.pop();
        String leftOperand = this.conditionOperands.pop();
        String compareFilter = rightOperand.equals("_id") || leftOperand.equals("_id") ? "{{{LEFT_OPERAND}}:{{{COMPARE_OPERATOR}}:{$oid:{{RIGHT_OPERAND}}}}}" : "{{{LEFT_OPERAND}}:{{{COMPARE_OPERATOR}}:{{RIGHT_OPERAND}}}}";
        String compareOperator = MongoTableUtils.getCompareOperator(operator);
        compareFilter = compareFilter.replace("{{COMPARE_OPERATOR}}", compareOperator);
        if (!rightOperand.matches("\\{.*}$") && !leftOperand.matches("\\{.*}$")) {
            if (leftOperand.matches("^strVar\\d*|^const\\d*") == rightOperand.matches("^strVar\\d*|^const\\d*")) {
                if (this.isHavingClause) {
                    throw new MongoTableException("The Mongo Event table only supports COMPARE operation between Table/ Stream attribute and Constant in HAVING clause. Please check your query and try again.");
                }
                throw new MongoTableException("MongoDB Event Table found operands '" + leftOperand + "' and '" + rightOperand + "' for COMPARE operation. The Mongo Event table only supports COMPARE operation between table attribute and Stream variable/ Constant. Please check your query and try again.");
            }
        } else {
            throw new MongoTableException("MongoDB Event Table found operands '" + leftOperand + "' and '" + rightOperand + "' for COMPARE operation. The Mongo Event table does not supports COMPARE operation between expressions. Please check your query and try again.");
        }
        compareFilter = !rightOperand.matches("^strVar\\d*|^const\\d*") ? compareFilter.replace("{{LEFT_OPERAND}}", rightOperand).replace("{{RIGHT_OPERAND}}", leftOperand) : compareFilter.replace("{{LEFT_OPERAND}}", leftOperand).replace("{{RIGHT_OPERAND}}", rightOperand);
        this.conditionOperands.push(compareFilter);
    }

    public void beginVisitCompareLeftOperand(Compare.Operator operator) {
    }

    public void endVisitCompareLeftOperand(Compare.Operator operator) {
    }

    public void beginVisitCompareRightOperand(Compare.Operator operator) {
    }

    public void endVisitCompareRightOperand(Compare.Operator operator) {
    }

    public void beginVisitIsNull(String streamId) {
        if (this.isHavingClause) {
            throw new MongoTableException("MongoDB Event Table does not support IS NULL in having clause.");
        }
    }

    public void endVisitIsNull(String streamId) {
        String operand = this.conditionOperands.pop();
        if (operand.matches("\\{.*}$") || operand.matches("^strVar\\d*|^const\\d*")) {
            throw new MongoTableException("MongoDB Event Table found operand '" + operand + "' for is NULL operation. The Mongo Event table only supports is NULL operation on a table attribute. Please check your query and try again.");
        }
        String isNullFilter = "{{{OPERAND}}:{$eq:null}}".replace("{{OPERAND}}", operand);
        this.conditionOperands.push(isNullFilter);
    }

    public void beginVisitIn(String storeId) {
        throw new MongoTableException("MongoDB Event Table does not support IN operations. Please check your query and try again.");
    }

    public void endVisitIn(String storeId) {
    }

    public void beginVisitMath(ExpressionVisitor.MathOperator mathOperator) {
        throw new MongoTableException("The Mongo Event table do not support MATH operations.  Please check your query and try again.");
    }

    public void endVisitMath(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void beginVisitMathLeftOperand(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void endVisitMathLeftOperand(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void beginVisitMathRightOperand(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void endVisitMathRightOperand(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void beginVisitAttributeFunction(String namespace, String functionName) {
        throw new MongoTableException("The Mongo Event table do not support Attribute functions.  Please check your query and try again.");
    }

    public void endVisitAttributeFunction(String namespace, String functionName) {
    }

    public void beginVisitParameterAttributeFunction(int index) {
    }

    public void endVisitParameterAttributeFunction(int index) {
    }

    public void beginVisitStreamVariable(String id, String streamId, String attributeName, Attribute.Type type) {
        String name = this.generateStreamVarName();
        this.placeholders.put(name, new Attribute(id, type));
        this.conditionOperands.push(name);
    }

    public void endVisitStreamVariable(String id, String streamId, String attributeName, Attribute.Type type) {
    }

    public void beginVisitConstant(Object value, Attribute.Type type) {
        String name = this.generateConstantName();
        this.placeholders.put(name, new Constant(value, type));
        this.conditionOperands.push(name);
    }

    public void endVisitConstant(Object value, Attribute.Type type) {
    }

    public void beginVisitStoreVariable(String storeId, String attributeName, Attribute.Type type) {
        this.conditionOperands.push(attributeName);
    }

    public void endVisitStoreVariable(String storeId, String attributeName, Attribute.Type type) {
    }

    private String generateStreamVarName() {
        String name = "strVar" + this.streamVarCount;
        ++this.streamVarCount;
        return name;
    }

    private String generateConstantName() {
        String name = "const" + this.constantCount;
        ++this.constantCount;
        return name;
    }
}

