/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.store.mongodb;

import io.siddhi.core.table.record.BaseExpressionVisitor;
import io.siddhi.core.table.record.ExpressionVisitor;
import io.siddhi.extension.store.mongodb.exception.MongoTableException;
import io.siddhi.extension.store.mongodb.util.Constant;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.expression.condition.Compare;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class MongoSetExpressionVisitor
extends BaseExpressionVisitor {
    private Stack<String> conditionOperands = new Stack();
    private Map<String, Object> placeholders = new HashMap<String, Object>();
    private int streamVarCount = 0;
    private int constantCount = 0;

    public String getCompiledCondition() {
        String compiledCondition = this.conditionOperands.pop();
        for (Map.Entry<String, Object> entry : this.placeholders.entrySet()) {
            if (!(entry.getValue() instanceof Constant)) continue;
            Constant constant = (Constant)entry.getValue();
            compiledCondition = constant.getType().equals((Object)Attribute.Type.STRING) ? compiledCondition.replaceAll(entry.getKey(), "'" + constant.getValue().toString() + "'") : compiledCondition.replaceAll(entry.getKey(), constant.getValue().toString());
            this.placeholders.remove(entry.getKey());
        }
        return compiledCondition;
    }

    public Map<String, Object> getPlaceholders() {
        return this.placeholders;
    }

    public void beginVisitAnd() {
    }

    public void endVisitAnd() {
        throw new MongoTableException("MongoDB Event Table does not support SET function.");
    }

    public void beginVisitAndLeftOperand() {
    }

    public void endVisitAndLeftOperand() {
    }

    public void beginVisitAndRightOperand() {
    }

    public void endVisitAndRightOperand() {
    }

    public void beginVisitOr() {
    }

    public void endVisitOr() {
        throw new MongoTableException("MongoDB Event Table does not support SET function.");
    }

    public void beginVisitOrLeftOperand() {
    }

    public void endVisitOrLeftOperand() {
    }

    public void beginVisitOrRightOperand() {
    }

    public void endVisitOrRightOperand() {
    }

    public void beginVisitNot() {
    }

    public void endVisitNot() {
        throw new MongoTableException("MongoDB Event Table does not support SET function.");
    }

    public void beginVisitCompare(Compare.Operator operator) {
    }

    public void endVisitCompare(Compare.Operator operator) {
        throw new MongoTableException("MongoDB Event Table does not support SET function.");
    }

    public void beginVisitCompareLeftOperand(Compare.Operator operator) {
    }

    public void endVisitCompareLeftOperand(Compare.Operator operator) {
    }

    public void beginVisitCompareRightOperand(Compare.Operator operator) {
    }

    public void endVisitCompareRightOperand(Compare.Operator operator) {
    }

    public void beginVisitIsNull(String streamId) {
    }

    public void endVisitIsNull(String streamId) {
        throw new MongoTableException("MongoDB Event Table does not support SET function.");
    }

    public void beginVisitIn(String storeId) {
        throw new MongoTableException("MongoDB Event Table does not support SET function.");
    }

    public void endVisitIn(String storeId) {
    }

    public void beginVisitMath(ExpressionVisitor.MathOperator mathOperator) {
        throw new MongoTableException("MongoDB Event Table does not support SET function.");
    }

    public void endVisitMath(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void beginVisitMathLeftOperand(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void endVisitMathLeftOperand(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void beginVisitMathRightOperand(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void endVisitMathRightOperand(ExpressionVisitor.MathOperator mathOperator) {
    }

    public void beginVisitAttributeFunction(String namespace, String functionName) {
        throw new MongoTableException("MongoDB Event Table does not support SET function.");
    }

    public void endVisitAttributeFunction(String namespace, String functionName) {
    }

    public void beginVisitParameterAttributeFunction(int index) {
    }

    public void endVisitParameterAttributeFunction(int index) {
    }

    public void beginVisitStreamVariable(String id, String streamId, String attributeName, Attribute.Type type) {
        String name = this.generateStreamVarName();
        this.placeholders.put(name, new Attribute(id, type));
        this.conditionOperands.push(name);
    }

    public void endVisitStreamVariable(String id, String streamId, String attributeName, Attribute.Type type) {
    }

    public void beginVisitConstant(Object value, Attribute.Type type) {
        String name = this.generateConstantName();
        this.placeholders.put(name, new Constant(value, type));
        this.conditionOperands.push(name);
    }

    public void endVisitConstant(Object value, Attribute.Type type) {
    }

    public void beginVisitStoreVariable(String storeId, String attributeName, Attribute.Type type) {
        this.conditionOperands.push(attributeName);
    }

    public void endVisitStoreVariable(String storeId, String attributeName, Attribute.Type type) {
    }

    private String generateStreamVarName() {
        String name = "strVar" + this.streamVarCount;
        ++this.streamVarCount;
        return name;
    }

    private String generateConstantName() {
        String name = "const" + this.constantCount;
        ++this.constantCount;
        return name;
    }
}

