/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.sdk.launcher;

import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.SiddhiManager;
import io.siddhi.sdk.launcher.debug.VMDebugManager;
import io.siddhi.sdk.launcher.exception.FileReadException;
import io.siddhi.sdk.launcher.exception.SLauncherException;
import io.siddhi.sdk.launcher.run.SiddhiRun;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class LauncherUtils {
    private static final Logger log = Logger.getLogger(LauncherUtils.class);

    public static void runProgram(boolean isDebugEnabled, String[] args) {
        if (args.length == 0 || args[0] == null) {
            throw new FileReadException("No Siddhi App file Path given");
        }
        String siddhiAppPath = args[0];
        String siddhiApp = LauncherUtils.validateAndGetSiddhdiApp(siddhiAppPath);
        String inputFile = "";
        if (args.length != 1 && args[1] != null && !args[1].equalsIgnoreCase("")) {
            String inputFilePath = args[1];
            try {
                inputFile = LauncherUtils.readText(inputFilePath);
            }
            catch (IOException e) {
                throw new FileReadException("Failed to read event input file:" + inputFilePath + ":" + e);
            }
        } else {
            log.info((Object)"Event Input file is not provided or file is empty");
        }
        if (!siddhiApp.equals("")) {
            if (!isDebugEnabled) {
                try {
                    SiddhiRun siddhiRun = new SiddhiRun();
                    siddhiRun.runSiddhi(siddhiApp, inputFile);
                }
                catch (InterruptedException e) {
                    throw new FileReadException("Siddhi App execution error: " + e);
                }
            } else {
                VMDebugManager vmDebugManager = VMDebugManager.getInstance();
                vmDebugManager.mainInit(siddhiAppPath, siddhiApp, inputFile);
            }
        } else {
            throw new FileReadException("No valid SiddhiApp found in the file");
        }
    }

    private static boolean validateSiddhiAppPath(String siddhiAppPath) {
        File siddhiAppFile = new File(siddhiAppPath);
        String fileName = siddhiAppFile.getName();
        String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (!siddhiAppFile.exists() || !siddhiAppFile.isFile()) {
            throw new FileReadException("Invalid siddhi app file path:" + siddhiAppPath);
        }
        if (!extension.equalsIgnoreCase("siddhi")) {
            throw new FileReadException("Invalid siddhi file extension detected in the file:" + extension);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String validateAndGetSiddhdiApp(String siddhiAppPath) {
        SiddhiManager siddhiManager = new SiddhiManager();
        String siddhiApp = "";
        boolean isValidSiddhiAppPath = LauncherUtils.validateSiddhiAppPath(siddhiAppPath);
        if (isValidSiddhiAppPath) {
            try {
                siddhiApp = LauncherUtils.readText(siddhiAppPath);
                SiddhiAppRuntime siddhiAppRuntime = null;
                try {
                    siddhiAppRuntime = siddhiManager.createSiddhiAppRuntime(siddhiApp);
                    siddhiAppRuntime.start();
                }
                finally {
                    if (siddhiAppRuntime != null) {
                        siddhiAppRuntime.shutdown();
                        siddhiManager.shutdown();
                    }
                }
            }
            catch (IOException e) {
                throw new FileReadException("Failed to read siddhi app file:" + siddhiAppPath + ":" + e);
            }
        }
        return siddhiApp;
    }

    private static String readText(String path) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));){
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line).append('\n');
            }
            String string = builder.toString();
            return string;
        }
    }

    public static SLauncherException createUsageException(String errorMsg) {
        SLauncherException launcherException = new SLauncherException();
        launcherException.addMessage("siddhi: " + errorMsg);
        return launcherException;
    }
}

