/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.sdk.launcher;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import io.siddhi.sdk.launcher.LauncherUtils;
import io.siddhi.sdk.launcher.SLauncherCmd;
import io.siddhi.sdk.launcher.exception.SLauncherException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;

public class Main {
    private static final Logger log = Logger.getLogger(Main.class);
    private static final String JC_UNKNOWN_OPTION_PREFIX = "Unknown option:";
    private static final String JC_EXPECTED_A_VALUE_AFTER_PARAMETER_PREFIX = "Expected a value after parameter";

    public static void main(String ... args) {
        try {
            Optional<SLauncherCmd> optionalInvokedCmd = Main.getInvokedCmd(args);
            optionalInvokedCmd.ifPresent(SLauncherCmd::execute);
        }
        catch (SLauncherException e) {
            log.error((Object)e.getMessage());
            Runtime.getRuntime().exit(1);
        }
        catch (Throwable e) {
            String msg = "siddhi: " + e.toString();
            log.error((Object)msg);
            Runtime.getRuntime().exit(1);
        }
    }

    private static Optional<SLauncherCmd> getInvokedCmd(String ... args) throws SLauncherException {
        try {
            RunCmd runCmd = new RunCmd();
            JCommander cmdParser = new JCommander((Object)runCmd);
            cmdParser.setProgramName("siddhi");
            cmdParser.parse(args);
            String parsedCmdName = cmdParser.getParsedCommand();
            if (parsedCmdName == null) {
                return Optional.of(runCmd);
            }
            Map commanderMap = cmdParser.getCommands();
            return Optional.of((SLauncherCmd)((JCommander)commanderMap.get(parsedCmdName)).getObjects().get(0));
        }
        catch (MissingCommandException e) {
            String errorMsg = "unknown command '" + e.getUnknownCommand() + "'";
            throw LauncherUtils.createUsageException(errorMsg);
        }
        catch (ParameterException e) {
            String msg = e.getMessage();
            if (msg == null) {
                throw LauncherUtils.createUsageException("internal error occurred");
            }
            if (msg.startsWith(JC_UNKNOWN_OPTION_PREFIX)) {
                String flag = msg.substring(JC_UNKNOWN_OPTION_PREFIX.length());
                throw LauncherUtils.createUsageException("unknown flag '" + flag.trim() + "'");
            }
            if (msg.startsWith(JC_EXPECTED_A_VALUE_AFTER_PARAMETER_PREFIX)) {
                String flag = msg.substring(JC_EXPECTED_A_VALUE_AFTER_PARAMETER_PREFIX.length());
                throw LauncherUtils.createUsageException("flag '" + flag.trim() + "' needs an argument");
            }
            throw LauncherUtils.createUsageException(msg);
        }
    }

    @Parameters(commandNames={"run"}, commandDescription="compile and run Siddhi program")
    private static class RunCmd
    implements SLauncherCmd {
        @Parameter(arity=1, description="arguments")
        private List<String> argList;
        @Parameter(names={"--debug"}, hidden=true)
        private String debugPort;
        @Parameter(names={"--siddhi.debug"}, hidden=true, description="remote debugging port")
        private String siddhiDebugPort;

        private RunCmd() {
        }

        @Override
        public void execute() {
            String[] programArgs;
            boolean debugMode = false;
            if (this.argList == null || this.argList.size() == 0) {
                throw new RuntimeException("No Siddhi app provided");
            }
            if (this.siddhiDebugPort != null) {
                System.setProperty("siddhi.debug", this.siddhiDebugPort);
                debugMode = true;
            }
            if (this.argList.size() >= 2) {
                this.argList.remove(0);
                programArgs = this.argList.toArray(new String[0]);
            } else {
                programArgs = new String[]{};
            }
            LauncherUtils.runProgram(debugMode, programArgs);
        }
    }
}

