/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.sdk.launcher.debug;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.channel.Channel;
import io.siddhi.core.SiddhiManager;
import io.siddhi.sdk.launcher.debug.BreakPointInfo;
import io.siddhi.sdk.launcher.debug.VMDebugServer;
import io.siddhi.sdk.launcher.debug.VMDebugSession;
import io.siddhi.sdk.launcher.debug.dto.CommandDTO;
import io.siddhi.sdk.launcher.debug.dto.MessageDTO;
import io.siddhi.sdk.launcher.debug.internal.DebugRuntime;
import io.siddhi.sdk.launcher.exception.DebugException;
import io.siddhi.sdk.launcher.util.InputFeeder;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class VMDebugManager {
    private static final Logger log = Logger.getLogger(VMDebugManager.class);
    private static VMDebugManager debugManagerInstance = null;
    private static SiddhiManager siddhiManager = new SiddhiManager();
    private VMDebugServer debugServer = new VMDebugServer();
    private VMDebugSession debugSession = new VMDebugSession();
    private boolean debugManagerInitialized = false;
    private InputFeeder inputFeeder = null;

    private VMDebugManager() {
    }

    public static VMDebugManager getInstance() {
        if (debugManagerInstance != null) {
            return debugManagerInstance;
        }
        return VMDebugManager.initialize();
    }

    private static synchronized VMDebugManager initialize() {
        if (debugManagerInstance == null) {
            debugManagerInstance = new VMDebugManager();
        }
        return debugManagerInstance;
    }

    public VMDebugSession getDebugSession() {
        return this.debugSession;
    }

    public SiddhiManager getSiddhiManager() {
        return siddhiManager;
    }

    public void mainInit(String siddhiAppPath, String siddhiApp, String inputFile) {
        if (this.debugManagerInitialized) {
            throw new DebugException("Debugger instance already initialized");
        }
        File f = new File(siddhiAppPath);
        String fileName = f.getName();
        DebugRuntime debugRuntime = new DebugRuntime(fileName, siddhiApp);
        this.debugSession.setDebugRuntime(debugRuntime);
        if (inputFile != null && !inputFile.equalsIgnoreCase("")) {
            this.inputFeeder = new InputFeeder(debugRuntime.getSiddhiAppRuntime(), inputFile);
        }
        this.debugServer.startServer();
        this.debugManagerInitialized = true;
    }

    public void processDebugCommand(String json) {
        try {
            this.processCommand(json);
        }
        catch (Exception e) {
            MessageDTO message = new MessageDTO();
            message.setCode("INVALID");
            message.setMessage(e.getMessage());
            this.debugServer.pushMessageToClient(this.debugSession, message);
        }
    }

    private void processCommand(String json) {
        ObjectMapper mapper = new ObjectMapper();
        CommandDTO command = null;
        try {
            command = (CommandDTO)mapper.readValue(json, CommandDTO.class);
        }
        catch (IOException e) {
            throw new DebugException("Invalid Command");
        }
        switch (command.getCommand()) {
            case "RESUME": {
                this.debugSession.getDebugRuntime().getDebugger().play();
                break;
            }
            case "STEP_OVER": {
                this.debugSession.getDebugRuntime().getDebugger().next();
                break;
            }
            case "STOP": {
                if (this.inputFeeder != null) {
                    this.inputFeeder.stop();
                }
                this.debugSession.stopDebug();
                this.debugSession.clearSession();
                break;
            }
            case "SET_POINTS": {
                this.debugSession.addDebugPoints(command.getPoints());
                this.sendAcknowledge(this.debugSession, "Debug points updated");
                break;
            }
            case "REMOVE_BREAKPOINT": {
                this.debugSession.removeDebugPoints(command.getPoints());
                this.sendAcknowledge(this.debugSession, "Debug point removed");
                break;
            }
            case "SEND_EVENT": {
                if (this.inputFeeder != null) {
                    this.inputFeeder.start();
                    this.sendAcknowledge(this.debugSession, "Input feeder started.");
                    break;
                }
                log.info((Object)"Input file is empty or null");
                break;
            }
            case "START": {
                this.debugSession.startDebug();
                this.sendAcknowledge(this.debugSession, "Debug started.");
                break;
            }
            default: {
                throw new DebugException("Invalid Command");
            }
        }
    }

    public void addDebugSession(Channel channel) throws DebugException {
        this.debugSession.setChannel(channel);
        this.sendAcknowledge(this.debugSession, "Channel registered.");
    }

    private boolean isDebugSessionActive() {
        return this.debugSession.getChannel() != null;
    }

    public void notifyDebugHit(VMDebugSession debugSession, BreakPointInfo breakPointInfo) {
        MessageDTO message = new MessageDTO();
        message.setCode("DEBUG_HIT");
        message.setMessage("Debug point hit.");
        message.setEventInfo(breakPointInfo.getEventInfo());
        message.setQueryName(breakPointInfo.getQueryName());
        message.setQueryState(breakPointInfo.getQueryState());
        String fileName = breakPointInfo.getFileName();
        int queryIndex = breakPointInfo.getQueryIndex();
        String queryTerminal = breakPointInfo.getQueryTerminal();
        message.setLocation(fileName, queryIndex, queryTerminal);
        this.debugServer.pushMessageToClient(debugSession, message);
    }

    public void notifyComplete(VMDebugSession debugSession) {
        MessageDTO message = new MessageDTO();
        message.setCode("COMPLETE");
        message.setMessage("Debug session completed.");
        this.debugServer.pushMessageToClient(debugSession, message);
    }

    public void notifyExit(VMDebugSession debugSession) {
        if (!this.isDebugSessionActive()) {
            return;
        }
        MessageDTO message = new MessageDTO();
        message.setCode("EXIT");
        message.setMessage("Exiting from debugger.");
        this.debugServer.pushMessageToClient(debugSession, message);
    }

    private void sendAcknowledge(VMDebugSession debugSession, String messageText) {
        MessageDTO message = new MessageDTO();
        message.setCode("ACK");
        message.setMessage(messageText);
        this.debugServer.pushMessageToClient(debugSession, message);
    }
}

