/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.sdk.launcher.debug;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4JLoggerFactory;
import io.siddhi.sdk.launcher.debug.VMDebugServerHandler;
import io.siddhi.sdk.launcher.debug.VMDebugSession;
import io.siddhi.sdk.launcher.debug.dto.MessageDTO;
import java.io.PrintStream;

public class VMDebugServer {
    public void startServer() {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Log4JLoggerFactory());
        Runnable run = this::startListning;
        Thread thread = new Thread(run);
        thread.setName("Message Listener");
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startListning() {
        int port = this.getDebugPort();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new DebugServerInitializer());
            Channel ch = b.bind(port).sync().channel();
            PrintStream out = System.out;
            out.println("Siddhi remote debugger is activated on port : " + port);
            ch.closeFuture().sync();
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    public void pushMessageToClient(VMDebugSession debugSession, MessageDTO status) {
        String json;
        ObjectMapper mapper = new ObjectMapper();
        try {
            json = mapper.writeValueAsString((Object)status);
        }
        catch (JsonProcessingException e) {
            json = "{ \"error\": true }";
        }
        debugSession.getChannel().write((Object)new TextWebSocketFrame(json));
        debugSession.getChannel().flush();
    }

    private int getDebugPort() {
        String debugPort = System.getProperty("siddhi.debug");
        if (debugPort == null || debugPort.equals("")) {
            debugPort = "5006";
        }
        return Integer.parseInt(debugPort);
    }

    static class DebugServerInitializer
    extends ChannelInitializer<SocketChannel> {
        DebugServerInitializer() {
        }

        public void initChannel(SocketChannel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
            pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
            pipeline.addLast(new ChannelHandler[]{new VMDebugServerHandler()});
        }
    }
}

