/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.sdk.launcher.util;

import com.google.gson.Gson;
import io.siddhi.core.SiddhiAppRuntime;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class InputFeeder
implements Runnable {
    private static final Logger log = Logger.getLogger(InputFeeder.class);
    private static final String DELAY = "delay";
    private static final String INPUT_DELIMITER = "=";
    private final SiddhiAppRuntime siddhiAppRuntime;
    private String input;
    private volatile AtomicBoolean running = new AtomicBoolean(false);
    private Thread thread = new Thread(this);

    public InputFeeder(SiddhiAppRuntime siddhiAppRuntime, String input) {
        this.siddhiAppRuntime = siddhiAppRuntime;
        this.input = input;
    }

    @Override
    public void run() {
        Scanner scanner = new Scanner(this.input);
        Gson gson = new Gson();
        while (scanner.hasNext() && this.running.get()) {
            String line = scanner.nextLine().trim();
            if (line.startsWith(DELAY)) {
                line = line.substring(6, line.length() - 1);
                try {
                    Thread.sleep(Integer.parseInt(line));
                }
                catch (InterruptedException e) {
                    log.error((Object)("Error in waiting for " + line + " milliseconds:" + e));
                }
                continue;
            }
            String[] components = line.split(INPUT_DELIMITER);
            String streamName = components[0];
            String event = components[1];
            Object[] data = (Object[])gson.fromJson(event, Object[].class);
            log.info((Object)("@Send: Stream: " + streamName + ", Event: " + event));
            try {
                this.siddhiAppRuntime.getInputHandler(streamName).send(data);
            }
            catch (InterruptedException e) {
                log.error((Object)("Error in sending event " + event + " to Siddhi:" + e));
            }
        }
        scanner.close();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void stop() {
        this.running.set(false);
    }

    public void start() {
        if (!this.running.get()) {
            this.running.set(true);
            this.thread.start();
        }
    }

    public void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            log.error((Object)"Error in joining the main thread behind the input feeder");
        }
    }
}

