/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.util.Enumeration;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class ClassPathUtils {
    private static final String FILE = "file";
    private static final String JAR = "jar";
    private static final FileSystemProvider JAR_PROVIDER;

    public static void consumeAsStreams(String resource, Consumer<InputStream> consumer) throws IOException {
        ClassPathUtils.consumeAsStreams(Thread.currentThread().getContextClassLoader(), resource, consumer);
    }

    public static void consumeAsStreams(ClassLoader cl, String resource, Consumer<InputStream> consumer) throws IOException {
        Enumeration<URL> resources;
        Enumeration<URL> enumeration = resources = cl == null ? ClassLoader.getSystemResources(resource) : cl.getResources(resource);
        while (resources.hasMoreElements()) {
            ClassPathUtils.consumeStream(resources.nextElement(), consumer);
        }
    }

    public static void consumeAsPaths(String resource, Consumer<Path> consumer) throws IOException {
        ClassPathUtils.consumeAsPaths(Thread.currentThread().getContextClassLoader(), resource, consumer);
    }

    public static void consumeAsPaths(ClassLoader cl, String resource, Consumer<Path> consumer) throws IOException {
        Enumeration<URL> resources;
        Enumeration<URL> enumeration = resources = cl == null ? ClassLoader.getSystemResources(resource) : cl.getResources(resource);
        while (resources.hasMoreElements()) {
            ClassPathUtils.consumeAsPath(resources.nextElement(), consumer);
        }
    }

    public static void consumeAsPath(URL url, Consumer<Path> consumer) {
        ClassPathUtils.processAsPath(url, p -> {
            consumer.accept((Path)p);
            return null;
        });
    }

    public static <R> R processAsPath(URL url, Function<Path, R> function) {
        if (JAR.equals(url.getProtocol())) {
            String file = url.getFile();
            int exclam = file.indexOf("!/");
            try {
                while (true) {
                    String subPath;
                    URL fileUrl;
                    if (exclam == -1) {
                        fileUrl = new URL(file);
                        subPath = "/";
                    } else {
                        fileUrl = new URL(file.substring(0, exclam));
                        subPath = file.substring(exclam + 1);
                    }
                    if (!fileUrl.getProtocol().equals(FILE)) {
                        throw new IllegalArgumentException("Sub-URL of JAR URL is expected to have a scheme of `file`");
                    }
                    Path proposedPath = ClassPathUtils.toLocalPath(fileUrl);
                    if (Files.isRegularFile(proposedPath, new LinkOption[0])) {
                        return ClassPathUtils.processAsJarPath(proposedPath, subPath, function);
                    }
                    if (exclam == -1) {
                        throw new IllegalArgumentException("File not found: " + String.valueOf(fileUrl));
                    }
                    exclam = file.indexOf("!/", exclam + 1);
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to create a URL for '" + file.substring(0, exclam) + "'", e);
            }
        }
        if (FILE.equals(url.getProtocol())) {
            return function.apply(ClassPathUtils.toLocalPath(url));
        }
        throw new IllegalArgumentException("Unexpected protocol " + url.getProtocol() + " for URL " + String.valueOf(url));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <R> R processAsJarPath(Path jarPath, String path, Function<Path, R> function) {
        try (FileSystem jarFs = JAR_PROVIDER.newFileSystem(jarPath, Map.of());){
            Path subPath;
            int idx;
            Path localPath = jarFs.getPath("/", new String[0]);
            int start = 0;
            while (true) {
                if ((idx = path.indexOf("!/", start)) == -1) {
                    R r = function.apply(localPath.resolve(path));
                    return r;
                }
                subPath = localPath.resolve(path.substring(0, idx));
                if (!Files.isDirectory(subPath, new LinkOption[0])) break;
                localPath = subPath;
                start = idx + 2;
            }
            R r = ClassPathUtils.processAsJarPath(subPath, path.substring(idx + 1), function);
            return r;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read " + String.valueOf(jarPath), e);
        }
    }

    public static void consumeStream(URL url, Consumer<InputStream> consumer) throws IOException {
        ClassPathUtils.readStream(url, is -> {
            consumer.accept((InputStream)is);
            return null;
        });
    }

    public static <R> R readStream(URL url, Function<InputStream, R> function) throws IOException {
        if (JAR.equals(url.getProtocol())) {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            try (InputStream is = urlConnection.getInputStream();){
                R r = function.apply(is);
                return r;
            }
        }
        if (FILE.equals(url.getProtocol())) {
            try (InputStream is = Files.newInputStream(ClassPathUtils.toLocalPath(url), new OpenOption[0]);){
                R r = function.apply(is);
                return r;
            }
        }
        try (InputStream is = url.openStream();){
            R r = function.apply(is);
            return r;
        }
    }

    public static Path toLocalPath(URL url) {
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to translate " + String.valueOf(url) + " to local path", e);
        }
    }

    static {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            JAR_PROVIDER = FileSystemProvider.installedProviders().stream().filter(p -> p.getScheme().equals(JAR)).findFirst().orElseThrow();
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }
}

