package io.smallrye.common.version;

import java.util.Locale;
import java.lang.IllegalStateException;
import io.smallrye.common.version.VersionSyntaxException;
import java.io.Serializable;
import java.lang.String;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
public class Messages_$bundle implements Messages, Serializable {
    private static final long serialVersionUID = 1L;
    protected Messages_$bundle() {}
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String expectedAlpha$str() {
        return "SRCOM03000: Expected alpha part";
    }
    @Override
    public final IllegalStateException expectedAlpha() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), expectedAlpha$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String expectedNumber$str() {
        return "SRCOM03001: Expected numeric part";
    }
    @Override
    public final IllegalStateException expectedNumber() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), expectedNumber$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expectedSep$str() {
        return "SRCOM03002: Expected separator";
    }
    @Override
    public final IllegalStateException expectedSep() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), expectedSep$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String iterationPastEnd$str() {
        return "SRCOM03003: Iteration past end of version string";
    }
    @Override
    public final NoSuchElementException iterationPastEnd() {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), iterationPastEnd$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCodePoint$str() {
        return "SRCOM03004: Invalid code point \"%s\" at offset %d of version string \"%s\"";
    }
    @Override
    public final io.smallrye.common.version.VersionSyntaxException invalidCodePoint(final String codePointString, final int start, final String version) {
        final io.smallrye.common.version.VersionSyntaxException result = new io.smallrye.common.version.VersionSyntaxException(String.format(getLoggingLocale(), invalidCodePoint$str(), codePointString, start, version));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tooLong$str() {
        return "SRCOM03005: Version string is too long";
    }
    @Override
    public final io.smallrye.common.version.VersionSyntaxException tooLong() {
        final io.smallrye.common.version.VersionSyntaxException result = new io.smallrye.common.version.VersionSyntaxException(String.format(getLoggingLocale(), tooLong$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonNumeric$str() {
        return "SRCOM03006: Unexpected non-numeric code point \"%s\" at offset %d of argument string \"%s\"";
    }
    @Override
    public final IllegalArgumentException nonNumeric(final String codePointString, final int offs, final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nonNumeric$str(), codePointString, offs, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedEnd$str() {
        return "SRCOM03007: Unexpected end of version string";
    }
    @Override
    public final io.smallrye.common.version.VersionSyntaxException unexpectedEnd() {
        final io.smallrye.common.version.VersionSyntaxException result = new io.smallrye.common.version.VersionSyntaxException(String.format(getLoggingLocale(), unexpectedEnd$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedExtra$str() {
        return "SRCOM03008: Unexpected extra content after version string";
    }
    @Override
    public final io.smallrye.common.version.VersionSyntaxException unexpectedExtra() {
        final io.smallrye.common.version.VersionSyntaxException result = new io.smallrye.common.version.VersionSyntaxException(String.format(getLoggingLocale(), unexpectedExtra$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emptyPreRelease$str() {
        return "SRCOM03009: Pre-release string may not be empty";
    }
    @Override
    public final io.smallrye.common.version.VersionSyntaxException emptyPreRelease() {
        final io.smallrye.common.version.VersionSyntaxException result = new io.smallrye.common.version.VersionSyntaxException(String.format(getLoggingLocale(), emptyPreRelease$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emptyBuild$str() {
        return "SRCOM03010: Build string may not be empty";
    }
    @Override
    public final io.smallrye.common.version.VersionSyntaxException emptyBuild() {
        final io.smallrye.common.version.VersionSyntaxException result = new io.smallrye.common.version.VersionSyntaxException(String.format(getLoggingLocale(), emptyBuild$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unboundedRange$str() {
        return "SRCOM03011: Unbounded range: %s";
    }
    @Override
    public final IllegalArgumentException unboundedRange(final String pattern) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unboundedRange$str(), pattern));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String singleVersionMustBeSurroundedByBrackets$str() {
        return "SRCOM03014: Single version must be surrounded by []: %s";
    }
    @Override
    public final IllegalArgumentException singleVersionMustBeSurroundedByBrackets(final String version) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), singleVersionMustBeSurroundedByBrackets$str(), version));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rangeDefiesVersionOrdering$str() {
        return "SRCOM03015: Range defies version ordering: %s";
    }
    @Override
    public final IllegalArgumentException rangeDefiesVersionOrdering(final String version) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), rangeDefiesVersionOrdering$str(), version));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rangeUnexpected$str() {
        return "SRCOM03016: Unexpected version range character: %s";
    }
    @Override
    public final IllegalArgumentException rangeUnexpected(final String version) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), rangeUnexpected$str(), version));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String standaloneVersionCannotBeBound$str() {
        return "SRCOM03017: Standalone version cannot have an upper bound";
    }
    @Override
    public final IllegalArgumentException standaloneVersionCannotBeBound() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), standaloneVersionCannotBeBound$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String inclusiveVersionCannotBeEmpty$str() {
        return "SRCOM03018: Inclusive versions cannot be empty";
    }
    @Override
    public final IllegalArgumentException inclusiveVersionCannotBeEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), inclusiveVersionCannotBeEmpty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
