package io.smallrye.stork.impl;

import io.smallrye.stork.impl.RoundRobinLoadBalancerProviderConfiguration;
import io.smallrye.stork.impl.RoundRobinLoadBalancerProvider;
import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.config.LoadBalancerConfig;
import io.smallrye.stork.api.ServiceDiscovery;

/**
LoadBalancerLoader for io.smallrye.stork.impl.RoundRobinLoadBalancerProvider
 */
 public class RoundRobinLoadBalancerProviderLoader implements io.smallrye.stork.spi.internal.LoadBalancerLoader {
   private final io.smallrye.stork.impl.RoundRobinLoadBalancerProvider provider = new io.smallrye.stork.impl.RoundRobinLoadBalancerProvider();
   @Override
   public LoadBalancer createLoadBalancer(LoadBalancerConfig config, ServiceDiscovery serviceDiscovery) {
      io.smallrye.stork.impl.RoundRobinLoadBalancerProviderConfiguration typedConfig = new io.smallrye.stork.impl.RoundRobinLoadBalancerProviderConfiguration(config.parameters());
      return provider.createLoadBalancer(typedConfig, serviceDiscovery);
   }
   @Override
   public String type() {
      return "round-robin";
   }
}
