package io.smallrye.stork.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import io.smallrye.stork.api.config.LoadBalancerConfig;

/**
 *  Configuration for the {@code RoundRobinLoadBalancerProvider} LoadBalancer.
 */
 public class RoundRobinConfiguration implements io.smallrye.stork.api.config.LoadBalancerConfig{
   private final Map<String, String> parameters;

   /**
    * Creates a new RoundRobinConfiguration
    *
    * @param params the parameters, must not be {@code null}
    */
   public RoundRobinConfiguration(Map<String, String> params) {
      parameters = Collections.unmodifiableMap(params);
   }

   /**
    * Creates a new RoundRobinConfiguration
    */
   public RoundRobinConfiguration() {
      parameters = Collections.emptyMap();
   }


  /**
   * @return the type
   */
   @Override
   public String type() {
      return "round-robin";
   }


   /**
    * @return the parameters
    */
   @Override
   public Map<String, String> parameters() {
      return parameters;
   }

   private RoundRobinConfiguration extend(String key, String value) {
      Map<String, String> copy = new HashMap<>(parameters);
      copy.put(key, value);
      return new RoundRobinConfiguration(copy);
   }
}
