package io.smallrye.stork.impl;

import io.smallrye.stork.impl.RoundRobinConfiguration;
import io.smallrye.stork.impl.RoundRobinLoadBalancerProvider;
import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.ServiceDiscovery;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.context.ApplicationScoped;

/**
 * LoadBalancerLoader for io.smallrye.stork.impl.RoundRobinLoadBalancerProvider
 */
 @ApplicationScoped
 public class RoundRobinLoadBalancerProviderLoader implements io.smallrye.stork.spi.internal.LoadBalancerLoader {
   private final io.smallrye.stork.impl.RoundRobinLoadBalancerProvider provider;
   public RoundRobinLoadBalancerProviderLoader() {
       io.smallrye.stork.impl.RoundRobinLoadBalancerProvider actual = null;
       try {
          actual = CDI.current().select(io.smallrye.stork.impl.RoundRobinLoadBalancerProvider.class).get();
       } catch(Exception e) { 
          // Use direct instantiation
          actual = new io.smallrye.stork.impl.RoundRobinLoadBalancerProvider();
       } 
       this.provider = actual;
   }

   @Override
   public LoadBalancer createLoadBalancer(ConfigWithType config, ServiceDiscovery serviceDiscovery) {
      io.smallrye.stork.impl.RoundRobinConfiguration typedConfig = new io.smallrye.stork.impl.RoundRobinConfiguration(config.parameters());
      return provider.createLoadBalancer(typedConfig, serviceDiscovery);
   }

  /**
   * @return the type
   */
   @Override
   public String type() {
      return "round-robin";
   }
}
