/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.consul;

import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.servicediscovery.consul.ConsulConfiguration;
import io.smallrye.stork.servicediscovery.consul.ConsulServiceDiscoveryProvider;
import io.smallrye.stork.spi.StorkInfrastructure;
import io.smallrye.stork.spi.internal.ServiceDiscoveryLoader;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;

@ApplicationScoped
public class ConsulServiceDiscoveryProviderLoader
implements ServiceDiscoveryLoader {
    private final ConsulServiceDiscoveryProvider provider;

    public ConsulServiceDiscoveryProviderLoader() {
        ConsulServiceDiscoveryProvider actual = null;
        try {
            actual = (ConsulServiceDiscoveryProvider)CDI.current().select(ConsulServiceDiscoveryProvider.class, new Annotation[0]).get();
        }
        catch (Exception e) {
            actual = new ConsulServiceDiscoveryProvider();
        }
        this.provider = actual;
    }

    public ServiceDiscovery createServiceDiscovery(ConfigWithType config, String serviceName, ServiceConfig serviceConfig, StorkInfrastructure storkInfrastructure) {
        ConsulConfiguration typedConfig = new ConsulConfiguration(config.parameters());
        return this.provider.createServiceDiscovery(typedConfig, serviceName, serviceConfig, storkInfrastructure);
    }

    public String type() {
        return "consul";
    }
}

