/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.ApplyFaultTolerance;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ApplyFaultToleranceConfig;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class ApplyFaultToleranceConfigImpl
implements ApplyFaultToleranceConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final ApplyFaultTolerance instance;
    private final boolean onMethod;
    private String _value;

    private ApplyFaultToleranceConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.applyFaultTolerance;
        this.onMethod = method.annotationsPresentDirectly.contains(ApplyFaultTolerance.class);
    }

    public static ApplyFaultToleranceConfigImpl create(FaultToleranceMethod method) {
        if (method.applyFaultTolerance == null) {
            return null;
        }
        if (!io.smallrye.faulttolerance.autoconfig.Config.isEnabled(ApplyFaultTolerance.class, (MethodDescriptor)method.method)) {
            return null;
        }
        return new ApplyFaultToleranceConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return ApplyFaultTolerance.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public String value() {
        if (this._value == null) {
            Config config = ConfigProvider.getConfig();
            this._value = this.onMethod ? (String)config.getOptionalValue(this.getConfigKeyForMethod("value"), String.class).orElse(null) : (String)config.getOptionalValue(this.getConfigKeyForClass("value"), String.class).orElse(null);
            if (this._value == null) {
                this._value = config.getOptionalValue("ApplyFaultTolerance/value", String.class).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    private String getConfigKeyForMethod(String key) {
        return this.method.declaringClass.getName() + "/" + this.method.name + "/ApplyFaultTolerance/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return this.method.declaringClass.getName() + "/ApplyFaultTolerance/" + key;
    }

    public void materialize() {
        this.value();
    }
}

