/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.faulttolerance.api.ApplyFaultTolerance;
import io.smallrye.faulttolerance.api.AsynchronousNonBlocking;
import io.smallrye.faulttolerance.api.BeforeRetry;
import io.smallrye.faulttolerance.api.CircuitBreakerName;
import io.smallrye.faulttolerance.api.CustomBackoff;
import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.api.RetryWhen;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.BeforeRetryConfigImpl;
import io.smallrye.faulttolerance.config.FallbackConfigImpl;
import io.smallrye.faulttolerance.config.SecurityActions;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public class FaultToleranceMethods {
    public static FaultToleranceMethod create(Class<?> beanClass, AnnotatedMethod<?> method) {
        HashSet<Class<? extends Annotation>> annotationsPresentDirectly = new HashSet<Class<? extends Annotation>>();
        FaultToleranceMethod result = new FaultToleranceMethod();
        result.beanClass = beanClass;
        result.method = FaultToleranceMethods.createMethodDescriptor(method);
        result.applyFaultTolerance = FaultToleranceMethods.getAnnotation(ApplyFaultTolerance.class, method, annotationsPresentDirectly);
        result.asynchronous = FaultToleranceMethods.getAnnotation(Asynchronous.class, method, annotationsPresentDirectly);
        result.asynchronousNonBlocking = FaultToleranceMethods.getAnnotation(AsynchronousNonBlocking.class, method, annotationsPresentDirectly);
        result.blocking = FaultToleranceMethods.getAnnotation(Blocking.class, method, annotationsPresentDirectly);
        result.nonBlocking = FaultToleranceMethods.getAnnotation(NonBlocking.class, method, annotationsPresentDirectly);
        result.bulkhead = FaultToleranceMethods.getAnnotation(Bulkhead.class, method, annotationsPresentDirectly);
        result.circuitBreaker = FaultToleranceMethods.getAnnotation(CircuitBreaker.class, method, annotationsPresentDirectly);
        result.circuitBreakerName = FaultToleranceMethods.getAnnotation(CircuitBreakerName.class, method, annotationsPresentDirectly);
        result.fallback = FaultToleranceMethods.getAnnotation(Fallback.class, method, annotationsPresentDirectly);
        result.rateLimit = FaultToleranceMethods.getAnnotation(RateLimit.class, method, annotationsPresentDirectly);
        result.retry = FaultToleranceMethods.getAnnotation(Retry.class, method, annotationsPresentDirectly);
        result.timeout = FaultToleranceMethods.getAnnotation(Timeout.class, method, annotationsPresentDirectly);
        result.customBackoff = FaultToleranceMethods.getAnnotation(CustomBackoff.class, method, annotationsPresentDirectly);
        result.exponentialBackoff = FaultToleranceMethods.getAnnotation(ExponentialBackoff.class, method, annotationsPresentDirectly);
        result.fibonacciBackoff = FaultToleranceMethods.getAnnotation(FibonacciBackoff.class, method, annotationsPresentDirectly);
        result.retryWhen = FaultToleranceMethods.getAnnotation(RetryWhen.class, method, annotationsPresentDirectly);
        result.beforeRetry = FaultToleranceMethods.getAnnotation(BeforeRetry.class, method, annotationsPresentDirectly);
        result.annotationsPresentDirectly = annotationsPresentDirectly;
        try {
            FaultToleranceMethods.searchForMethods(result, beanClass, method.getJavaMember());
        }
        catch (PrivilegedActionException e) {
            throw new FaultToleranceDefinitionException((Throwable)e);
        }
        return result;
    }

    private static MethodDescriptor createMethodDescriptor(AnnotatedMethod<?> cdiMethod) {
        MethodDescriptor result = new MethodDescriptor();
        result.declaringClass = cdiMethod.getJavaMember().getDeclaringClass();
        result.name = cdiMethod.getJavaMember().getName();
        result.parameterTypes = cdiMethod.getJavaMember().getParameterTypes();
        result.returnType = cdiMethod.getJavaMember().getReturnType();
        return result;
    }

    private static <A extends Annotation> A getAnnotation(Class<A> annotationType, AnnotatedMethod<?> cdiMethod, Set<Class<? extends Annotation>> directlyPresent) {
        if (cdiMethod.isAnnotationPresent(annotationType)) {
            directlyPresent.add(annotationType);
            return (A)cdiMethod.getAnnotation(annotationType);
        }
        return (A)cdiMethod.getDeclaringType().getAnnotation(annotationType);
    }

    public static FaultToleranceMethod create(Class<?> beanClass, Method method) {
        HashSet<Class<? extends Annotation>> annotationsPresentDirectly = new HashSet<Class<? extends Annotation>>();
        FaultToleranceMethod result = new FaultToleranceMethod();
        result.beanClass = beanClass;
        result.method = FaultToleranceMethods.createMethodDescriptor(method);
        result.applyFaultTolerance = FaultToleranceMethods.getAnnotation(ApplyFaultTolerance.class, method, beanClass, annotationsPresentDirectly);
        result.asynchronous = FaultToleranceMethods.getAnnotation(Asynchronous.class, method, beanClass, annotationsPresentDirectly);
        result.asynchronousNonBlocking = FaultToleranceMethods.getAnnotation(AsynchronousNonBlocking.class, method, beanClass, annotationsPresentDirectly);
        result.blocking = FaultToleranceMethods.getAnnotation(Blocking.class, method, beanClass, annotationsPresentDirectly);
        result.nonBlocking = FaultToleranceMethods.getAnnotation(NonBlocking.class, method, beanClass, annotationsPresentDirectly);
        result.bulkhead = FaultToleranceMethods.getAnnotation(Bulkhead.class, method, beanClass, annotationsPresentDirectly);
        result.circuitBreaker = FaultToleranceMethods.getAnnotation(CircuitBreaker.class, method, beanClass, annotationsPresentDirectly);
        result.circuitBreakerName = FaultToleranceMethods.getAnnotation(CircuitBreakerName.class, method, beanClass, annotationsPresentDirectly);
        result.fallback = FaultToleranceMethods.getAnnotation(Fallback.class, method, beanClass, annotationsPresentDirectly);
        result.rateLimit = FaultToleranceMethods.getAnnotation(RateLimit.class, method, beanClass, annotationsPresentDirectly);
        result.retry = FaultToleranceMethods.getAnnotation(Retry.class, method, beanClass, annotationsPresentDirectly);
        result.timeout = FaultToleranceMethods.getAnnotation(Timeout.class, method, beanClass, annotationsPresentDirectly);
        result.customBackoff = FaultToleranceMethods.getAnnotation(CustomBackoff.class, method, beanClass, annotationsPresentDirectly);
        result.exponentialBackoff = FaultToleranceMethods.getAnnotation(ExponentialBackoff.class, method, beanClass, annotationsPresentDirectly);
        result.fibonacciBackoff = FaultToleranceMethods.getAnnotation(FibonacciBackoff.class, method, beanClass, annotationsPresentDirectly);
        result.retryWhen = FaultToleranceMethods.getAnnotation(RetryWhen.class, method, beanClass, annotationsPresentDirectly);
        result.beforeRetry = FaultToleranceMethods.getAnnotation(BeforeRetry.class, method, beanClass, annotationsPresentDirectly);
        result.annotationsPresentDirectly = annotationsPresentDirectly;
        try {
            FaultToleranceMethods.searchForMethods(result, beanClass, method);
        }
        catch (PrivilegedActionException e) {
            throw new FaultToleranceDefinitionException((Throwable)e);
        }
        return result;
    }

    private static MethodDescriptor createMethodDescriptor(Method reflectiveMethod) {
        MethodDescriptor result = new MethodDescriptor();
        result.declaringClass = reflectiveMethod.getDeclaringClass();
        result.name = reflectiveMethod.getName();
        result.parameterTypes = reflectiveMethod.getParameterTypes();
        result.returnType = reflectiveMethod.getReturnType();
        return result;
    }

    private static <A extends Annotation> A getAnnotation(Class<A> annotationType, Method reflectiveMethod, Class<?> beanClass, Set<Class<? extends Annotation>> directlyPresent) {
        if (reflectiveMethod.isAnnotationPresent(annotationType)) {
            directlyPresent.add(annotationType);
            return reflectiveMethod.getAnnotation(annotationType);
        }
        return FaultToleranceMethods.getAnnotationFromClass(beanClass, annotationType);
    }

    private static <A extends Annotation> A getAnnotationFromClass(Class<?> clazz, Class<A> annotationType) {
        while (clazz != null) {
            A annotation = clazz.getAnnotation(annotationType);
            if (annotation != null) {
                return annotation;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private static void searchForMethods(FaultToleranceMethod result, Class<?> beanClass, Method method) throws PrivilegedActionException {
        String beforeRetryMethod;
        BeforeRetryConfigImpl beforeRetryConfig;
        String fallbackMethod;
        FallbackConfigImpl fallbackConfig;
        if (result.fallback != null && (fallbackConfig = FallbackConfigImpl.create(result)) != null && !"".equals(fallbackMethod = fallbackConfig.fallbackMethod())) {
            Class<?> declaringClass = method.getDeclaringClass();
            Type[] parameterTypes = method.getGenericParameterTypes();
            Type returnType = method.getGenericReturnType();
            result.fallbackMethod = FaultToleranceMethods.createMethodDescriptorIfNotNull(SecurityActions.findFallbackMethod(beanClass, declaringClass, fallbackMethod, parameterTypes, returnType));
            result.fallbackMethodsWithExceptionParameter = FaultToleranceMethods.createMethodDescriptorsIfNotEmpty(SecurityActions.findFallbackMethodsWithExceptionParameter(beanClass, declaringClass, fallbackMethod, parameterTypes, returnType));
        }
        if (result.beforeRetry != null && (beforeRetryConfig = BeforeRetryConfigImpl.create(result)) != null && !"".equals(beforeRetryMethod = beforeRetryConfig.methodName())) {
            result.beforeRetryMethod = FaultToleranceMethods.createMethodDescriptorIfNotNull(SecurityActions.findBeforeRetryMethod(beanClass, method.getDeclaringClass(), beforeRetryMethod));
        }
    }

    private static MethodDescriptor createMethodDescriptorIfNotNull(Method reflectiveMethod) {
        return reflectiveMethod == null ? null : FaultToleranceMethods.createMethodDescriptor(reflectiveMethod);
    }

    private static List<MethodDescriptor> createMethodDescriptorsIfNotEmpty(Collection<Method> reflectiveMethods) {
        if (reflectiveMethods.isEmpty()) {
            return null;
        }
        ArrayList<MethodDescriptor> result = new ArrayList<MethodDescriptor>(reflectiveMethods.size());
        for (Method reflectiveMethod : reflectiveMethods) {
            result.add(FaultToleranceMethods.createMethodDescriptor(reflectiveMethod));
        }
        return result;
    }
}

