/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.Config;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public interface BulkheadConfig
extends Bulkhead,
Config {
    default public void validate() {
        String INVALID_BULKHEAD_ON = "Invalid @Bulkhead on ";
        if (this.value() < 0) {
            throw new FaultToleranceDefinitionException("Invalid @Bulkhead on " + String.valueOf(this.method()) + ": value shouldn't be lower than 0");
        }
        if (this.waitingTaskQueue() < 1) {
            throw new FaultToleranceDefinitionException("Invalid @Bulkhead on " + String.valueOf(this.method()) + ": waitingTaskQueue shouldn't be lower than 1");
        }
        try {
            Math.addExact(this.value(), this.waitingTaskQueue());
        }
        catch (ArithmeticException e) {
            throw new FaultToleranceDefinitionException("Invalid @Bulkhead on " + String.valueOf(this.method()) + ": bulkhead capacity overflow, " + this.value() + " + " + this.waitingTaskQueue() + " = " + (this.value() + this.waitingTaskQueue()));
        }
    }
}

