/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ConfigUtil;
import io.smallrye.faulttolerance.config.ExponentialBackoffConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class ExponentialBackoffConfigImpl
implements ExponentialBackoffConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final ExponentialBackoff instance;
    private final boolean onMethod;
    private Integer _factor;
    private Long _maxDelay;
    private ChronoUnit _maxDelayUnit;

    private ExponentialBackoffConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.exponentialBackoff;
        this.onMethod = method.annotationsPresentDirectly.contains(ExponentialBackoff.class);
    }

    public static ExponentialBackoffConfigImpl create(FaultToleranceMethod method) {
        if (method.exponentialBackoff == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(ExponentialBackoff.class, method.method)) {
            return null;
        }
        return new ExponentialBackoffConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return ExponentialBackoff.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public int factor() {
        if (this._factor == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(ExponentialBackoff.class, "factor", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(ExponentialBackoff.class, "factor", this.method.declaringClass, this.method.name);
                this._factor = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(ExponentialBackoff.class, "factor", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(ExponentialBackoff.class, "factor", this.method.declaringClass);
                this._factor = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            }
            if (this._factor == null) {
                newKey = ConfigUtil.newKey(ExponentialBackoff.class, "factor");
                oldKey = ConfigUtil.oldKey(ExponentialBackoff.class, "factor");
                this._factor = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            }
            if (this._factor == null) {
                this._factor = this.instance.factor();
            }
        }
        return this._factor;
    }

    public long maxDelay() {
        if (this._maxDelay == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(ExponentialBackoff.class, "maxDelay", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(ExponentialBackoff.class, "maxDelay", this.method.declaringClass, this.method.name);
                this._maxDelay = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(ExponentialBackoff.class, "maxDelay", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(ExponentialBackoff.class, "maxDelay", this.method.declaringClass);
                this._maxDelay = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._maxDelay == null) {
                newKey = ConfigUtil.newKey(ExponentialBackoff.class, "maxDelay");
                oldKey = ConfigUtil.oldKey(ExponentialBackoff.class, "maxDelay");
                this._maxDelay = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._maxDelay == null) {
                this._maxDelay = this.instance.maxDelay();
            }
        }
        return this._maxDelay;
    }

    public ChronoUnit maxDelayUnit() {
        if (this._maxDelayUnit == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(ExponentialBackoff.class, "maxDelayUnit", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(ExponentialBackoff.class, "maxDelayUnit", this.method.declaringClass, this.method.name);
                this._maxDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(ExponentialBackoff.class, "maxDelayUnit", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(ExponentialBackoff.class, "maxDelayUnit", this.method.declaringClass);
                this._maxDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._maxDelayUnit == null) {
                newKey = ConfigUtil.newKey(ExponentialBackoff.class, "maxDelayUnit");
                oldKey = ConfigUtil.oldKey(ExponentialBackoff.class, "maxDelayUnit");
                this._maxDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._maxDelayUnit == null) {
                this._maxDelayUnit = this.instance.maxDelayUnit();
            }
        }
        return this._maxDelayUnit;
    }

    public void materialize() {
        this.factor();
        this.maxDelay();
        this.maxDelayUnit();
    }
}

