/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;

public class OpenTelemetryRecorder
implements MetricsRecorder {
    private static final List<Double> BUCKET_BOUNDARIES = List.of(0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0);
    private static final double NANOS_TO_SECONDS = 1.0E-9;
    private static final AttributeKey<String> METHOD = AttributeKey.stringKey((String)"method");
    private static final AttributeKey<String> RESULT = AttributeKey.stringKey((String)"result");
    private static final String RESULT_VALUE_RETURNED = "valueReturned";
    private static final String RESULT_EXCEPTION_THROWN = "exceptionThrown";
    private static final AttributeKey<String> FALLBACK = AttributeKey.stringKey((String)"fallback");
    private static final String FALLBACK_APPLIED = "applied";
    private static final String FALLBACK_NOT_APPLIED = "notApplied";
    private static final String FALLBACK_NOT_DEFINED = "notDefined";
    private static final AttributeKey<String> RETRIED = AttributeKey.stringKey((String)"retried");
    private static final String RETRIED_TRUE = "true";
    private static final String RETRIED_FALSE = "false";
    private static final AttributeKey<String> RETRY_RESULT = AttributeKey.stringKey((String)"retryResult");
    private static final String RETRY_RESULT_VALUE_RETURNED = "valueReturned";
    private static final String RETRY_RESULT_EXCEPTION_NOT_RETRYABLE = "exceptionNotRetryable";
    private static final String RETRY_RESULT_MAX_RETRIES_REACHED = "maxRetriesReached";
    private static final String RETRY_RESULT_MAX_DURATION_REACHED = "maxDurationReached";
    private static final AttributeKey<String> TIMED_OUT = AttributeKey.stringKey((String)"timedOut");
    private static final String TIMED_OUT_TRUE = "true";
    private static final String TIMED_OUT_FALSE = "false";
    private static final AttributeKey<String> CIRCUIT_BREAKER_RESULT = AttributeKey.stringKey((String)"circuitBreakerResult");
    private static final String CIRCUIT_BREAKER_RESULT_SUCCESS = "success";
    private static final String CIRCUIT_BREAKER_RESULT_FAILURE = "failure";
    private static final String CIRCUIT_BREAKER_RESULT_CB_OPEN = "circuitBreakerOpen";
    private static final AttributeKey<String> CIRCUIT_BREAKER_STATE = AttributeKey.stringKey((String)"state");
    private static final String CIRCUIT_BREAKER_STATE_CLOSED = "closed";
    private static final String CIRCUIT_BREAKER_STATE_OPEN = "open";
    private static final String CIRCUIT_BREAKER_STATE_HALF_OPEN = "halfOpen";
    private static final AttributeKey<String> BULKHEAD_RESULT = AttributeKey.stringKey((String)"bulkheadResult");
    private static final String BULKHEAD_RESULT_ACCEPTED = "accepted";
    private static final String BULKHEAD_RESULT_REJECTED = "rejected";
    private static final AttributeKey<String> RATE_LIMIT_RESULT = AttributeKey.stringKey((String)"rateLimitResult");
    private static final String RATE_LIMIT_RESULT_PERMITTED = "permitted";
    private static final String RATE_LIMIT_RESULT_REJECTED = "rejected";
    private final Meter meter;
    private final String methodName;
    private final LongCounter invocationsTotal;
    private final LongCounter retryCallsTotal;
    private final LongCounter retryRetriesTotal;
    private final LongCounter timeoutCallsTotal;
    private final DoubleHistogram timeoutExecutionDuration;
    private final LongCounter circuitBreakerCallsTotal;
    private final LongCounter circuitBreakerOpenedTotal;
    private final LongCounter bulkheadCallsTotal;
    private final DoubleHistogram bulkheadRunningDuration;
    private final DoubleHistogram bulkheadWaitingDuration;
    private final LongCounter rateLimitCallsTotal;

    public OpenTelemetryRecorder(Meter meter, MeteredOperation operation) {
        this.meter = meter;
        this.methodName = operation.name();
        this.invocationsTotal = meter.counterBuilder("ft.invocations.total").build();
        if (operation.hasRetry()) {
            this.retryCallsTotal = meter.counterBuilder("ft.retry.calls.total").build();
            this.retryRetriesTotal = meter.counterBuilder("ft.retry.retries.total").build();
        } else {
            this.retryCallsTotal = null;
            this.retryRetriesTotal = null;
        }
        if (operation.hasTimeout()) {
            this.timeoutCallsTotal = meter.counterBuilder("ft.timeout.calls.total").build();
            this.timeoutExecutionDuration = meter.histogramBuilder("ft.timeout.executionDuration").setUnit("seconds").setExplicitBucketBoundariesAdvice(BUCKET_BOUNDARIES).build();
        } else {
            this.timeoutCallsTotal = null;
            this.timeoutExecutionDuration = null;
        }
        if (operation.hasCircuitBreaker()) {
            this.circuitBreakerCallsTotal = meter.counterBuilder("ft.circuitbreaker.calls.total").build();
            this.circuitBreakerOpenedTotal = meter.counterBuilder("ft.circuitbreaker.opened.total").build();
        } else {
            this.circuitBreakerCallsTotal = null;
            this.circuitBreakerOpenedTotal = null;
        }
        if (operation.hasBulkhead()) {
            this.bulkheadCallsTotal = meter.counterBuilder("ft.bulkhead.calls.total").build();
            this.bulkheadRunningDuration = meter.histogramBuilder("ft.bulkhead.runningDuration").setUnit("seconds").setExplicitBucketBoundariesAdvice(BUCKET_BOUNDARIES).build();
            this.bulkheadWaitingDuration = operation.isAsynchronous() ? meter.histogramBuilder("ft.bulkhead.waitingDuration").setUnit("seconds").setExplicitBucketBoundariesAdvice(BUCKET_BOUNDARIES).build() : null;
        } else {
            this.bulkheadCallsTotal = null;
            this.bulkheadRunningDuration = null;
            this.bulkheadWaitingDuration = null;
        }
        this.rateLimitCallsTotal = operation.hasRateLimit() ? meter.counterBuilder("ft.ratelimit.calls.total").build() : null;
    }

    private void registerAsyncUpDownCounter(LongSupplier supplier, String name, Attributes attributes) {
        this.meter.upDownCounterBuilder(name).buildWithCallback(m -> m.record(supplier.getAsLong(), attributes));
    }

    private void registerAsyncUpDownCounter(BooleanSupplier supplier, String name, Attributes attributes) {
        this.meter.upDownCounterBuilder(name).buildWithCallback(m -> m.record(supplier.getAsBoolean() ? 1L : 0L, attributes));
    }

    private void registerAsyncCounter(LongSupplier supplier, String name, String unit, Attributes attributes) {
        this.meter.counterBuilder(name).setUnit(unit).buildWithCallback(m -> m.record(supplier.getAsLong(), attributes));
    }

    @Override
    public void executionFinished(boolean succeeded, boolean fallbackDefined, boolean fallbackApplied) {
        String fallback = fallbackDefined ? (fallbackApplied ? FALLBACK_APPLIED : FALLBACK_NOT_APPLIED) : FALLBACK_NOT_DEFINED;
        this.invocationsTotal.add(1L, Attributes.of(METHOD, (Object)this.methodName, RESULT, (Object)(succeeded ? "valueReturned" : RESULT_EXCEPTION_THROWN), FALLBACK, (Object)fallback));
    }

    @Override
    public void retryAttempted() {
        this.retryRetriesTotal.add(1L, Attributes.of(METHOD, (Object)this.methodName));
    }

    @Override
    public void retryValueReturned(boolean retried) {
        this.retryCallsTotal.add(1L, Attributes.of(METHOD, (Object)this.methodName, RETRIED, (Object)(retried ? "true" : "false"), RETRY_RESULT, (Object)"valueReturned"));
    }

    @Override
    public void retryExceptionNotRetryable(boolean retried) {
        this.retryCallsTotal.add(1L, Attributes.of(METHOD, (Object)this.methodName, RETRIED, (Object)(retried ? "true" : "false"), RETRY_RESULT, (Object)RETRY_RESULT_EXCEPTION_NOT_RETRYABLE));
    }

    @Override
    public void retryMaxRetriesReached(boolean retried) {
        this.retryCallsTotal.add(1L, Attributes.of(METHOD, (Object)this.methodName, RETRIED, (Object)(retried ? "true" : "false"), RETRY_RESULT, (Object)RETRY_RESULT_MAX_RETRIES_REACHED));
    }

    @Override
    public void retryMaxDurationReached(boolean retried) {
        this.retryCallsTotal.add(1L, Attributes.of(METHOD, (Object)this.methodName, RETRIED, (Object)(retried ? "true" : "false"), RETRY_RESULT, (Object)RETRY_RESULT_MAX_DURATION_REACHED));
    }

    @Override
    public void timeoutFinished(boolean timedOut, long time) {
        this.timeoutCallsTotal.add(1L, Attributes.of(METHOD, (Object)this.methodName, TIMED_OUT, (Object)(timedOut ? "true" : "false")));
        this.timeoutExecutionDuration.record((double)time * 1.0E-9, Attributes.of(METHOD, (Object)this.methodName));
    }

    @Override
    public void circuitBreakerFinished(CircuitBreakerEvents.Result result) {
        String circuitBreakerResult = null;
        switch (result) {
            case SUCCESS: {
                circuitBreakerResult = CIRCUIT_BREAKER_RESULT_SUCCESS;
                break;
            }
            case FAILURE: {
                circuitBreakerResult = CIRCUIT_BREAKER_RESULT_FAILURE;
                break;
            }
            case PREVENTED: {
                circuitBreakerResult = CIRCUIT_BREAKER_RESULT_CB_OPEN;
            }
        }
        this.circuitBreakerCallsTotal.add(1L, Attributes.of(METHOD, (Object)this.methodName, CIRCUIT_BREAKER_RESULT, (Object)circuitBreakerResult));
    }

    @Override
    public void circuitBreakerMovedToOpen() {
        this.circuitBreakerOpenedTotal.add(1L, Attributes.of(METHOD, (Object)this.methodName));
    }

    @Override
    public void registerCircuitBreakerIsClosed(BooleanSupplier supplier) {
        this.registerAsyncUpDownCounter(supplier, "ft.circuitbreaker.state.current", Attributes.of(METHOD, (Object)this.methodName, CIRCUIT_BREAKER_STATE, (Object)CIRCUIT_BREAKER_STATE_CLOSED));
    }

    @Override
    public void registerCircuitBreakerIsOpen(BooleanSupplier supplier) {
        this.registerAsyncUpDownCounter(supplier, "ft.circuitbreaker.state.current", Attributes.of(METHOD, (Object)this.methodName, CIRCUIT_BREAKER_STATE, (Object)CIRCUIT_BREAKER_STATE_OPEN));
    }

    @Override
    public void registerCircuitBreakerIsHalfOpen(BooleanSupplier supplier) {
        this.registerAsyncUpDownCounter(supplier, "ft.circuitbreaker.state.current", Attributes.of(METHOD, (Object)this.methodName, CIRCUIT_BREAKER_STATE, (Object)CIRCUIT_BREAKER_STATE_HALF_OPEN));
    }

    @Override
    public void registerCircuitBreakerTimeSpentInClosed(LongSupplier supplier) {
        this.registerAsyncCounter(supplier, "ft.circuitbreaker.state.total", "nanoseconds", Attributes.of(METHOD, (Object)this.methodName, CIRCUIT_BREAKER_STATE, (Object)CIRCUIT_BREAKER_STATE_CLOSED));
    }

    @Override
    public void registerCircuitBreakerTimeSpentInOpen(LongSupplier supplier) {
        this.registerAsyncCounter(supplier, "ft.circuitbreaker.state.total", "nanoseconds", Attributes.of(METHOD, (Object)this.methodName, CIRCUIT_BREAKER_STATE, (Object)CIRCUIT_BREAKER_STATE_OPEN));
    }

    @Override
    public void registerCircuitBreakerTimeSpentInHalfOpen(LongSupplier supplier) {
        this.registerAsyncCounter(supplier, "ft.circuitbreaker.state.total", "nanoseconds", Attributes.of(METHOD, (Object)this.methodName, CIRCUIT_BREAKER_STATE, (Object)CIRCUIT_BREAKER_STATE_HALF_OPEN));
    }

    @Override
    public void bulkheadDecisionMade(boolean accepted) {
        this.bulkheadCallsTotal.add(1L, Attributes.of(METHOD, (Object)this.methodName, BULKHEAD_RESULT, (Object)(accepted ? BULKHEAD_RESULT_ACCEPTED : "rejected")));
    }

    @Override
    public void registerBulkheadExecutionsRunning(LongSupplier supplier) {
        this.registerAsyncUpDownCounter(supplier, "ft.bulkhead.executionsRunning", Attributes.of(METHOD, (Object)this.methodName));
    }

    @Override
    public void registerBulkheadExecutionsWaiting(LongSupplier supplier) {
        this.registerAsyncUpDownCounter(supplier, "ft.bulkhead.executionsWaiting", Attributes.of(METHOD, (Object)this.methodName));
    }

    @Override
    public void updateBulkheadRunningDuration(long time) {
        this.bulkheadRunningDuration.record((double)time * 1.0E-9, Attributes.of(METHOD, (Object)this.methodName));
    }

    @Override
    public void updateBulkheadWaitingDuration(long time) {
        this.bulkheadWaitingDuration.record((double)time * 1.0E-9, Attributes.of(METHOD, (Object)this.methodName));
    }

    @Override
    public void rateLimitDecisionMade(boolean permitted) {
        this.rateLimitCallsTotal.add(1L, Attributes.of(METHOD, (Object)this.methodName, RATE_LIMIT_RESULT, (Object)(permitted ? RATE_LIMIT_RESULT_PERMITTED : "rejected")));
    }
}

