/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.apiimpl;

import io.smallrye.faulttolerance.api.Guard;
import io.smallrye.faulttolerance.core.apiimpl.GuardImpl;
import jakarta.enterprise.util.TypeLiteral;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class LazyGuard
implements Guard {
    private final Supplier<GuardImpl> builder;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile GuardImpl instance;

    LazyGuard(Supplier<GuardImpl> builder) {
        this.builder = builder;
    }

    public <T> T call(Callable<T> action, Class<T> type) throws Exception {
        return this.instance().call(action, type);
    }

    public <T> T call(Callable<T> action, TypeLiteral<T> type) throws Exception {
        return this.instance().call(action, type);
    }

    public <T> T get(Supplier<T> action, Class<T> type) {
        return this.instance().get(action, type);
    }

    public <T> T get(Supplier<T> action, TypeLiteral<T> type) {
        return this.instance().get(action, type);
    }

    public GuardImpl instance() {
        GuardImpl instance = this.instance;
        if (instance == null) {
            this.lock.lock();
            try {
                instance = this.instance;
                if (instance == null) {
                    this.instance = instance = this.builder.get();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return instance;
    }
}

