/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.scalar.time;

import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class DateCoercing
implements Coercing {
    private final Class[] supportedTypes;
    private final String name;

    public DateCoercing(String name, Class ... supportedTypes) {
        this.name = name;
        this.supportedTypes = supportedTypes;
    }

    private Object convertImpl(Object input) {
        for (Class supportedType : this.supportedTypes) {
            if (!supportedType.isInstance(input)) continue;
            return supportedType.cast(input);
        }
        if (input instanceof String) {
            return input;
        }
        throw SmallRyeGraphQLServerMessages.msg.unknownDateFormat(input.toString());
    }

    public Object serialize(Object input) {
        if (input == null) {
            return null;
        }
        try {
            return this.convertImpl(input);
        }
        catch (DateTimeException e) {
            throw SmallRyeGraphQLServerMessages.msg.coercingSerializeException(this.name, input.getClass().getSimpleName(), e);
        }
    }

    public Object parseValue(Object input) {
        try {
            return this.convertImpl(input);
        }
        catch (DateTimeException e) {
            throw SmallRyeGraphQLServerMessages.msg.coercingParseValueException(this.name, input.getClass().getSimpleName(), e);
        }
    }

    public Object parseLiteral(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof StringValue) {
            return ((StringValue)input).getValue();
        }
        throw SmallRyeGraphQLServerMessages.msg.coercingParseLiteralException(input.getClass().getSimpleName());
    }

    public Value<?> valueToLiteral(Object input) {
        String formattedDate;
        Object s = this.serialize(input);
        if (s instanceof String) {
            return StringValue.newStringValue((String)((String)s)).build();
        }
        if (s instanceof LocalDate) {
            formattedDate = DateTimeFormatter.ISO_LOCAL_DATE.format((LocalDate)s);
        } else if (s instanceof LocalTime) {
            formattedDate = DateTimeFormatter.ISO_LOCAL_TIME.format((LocalTime)s);
        } else if (s instanceof LocalDateTime) {
            formattedDate = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format((LocalDateTime)s);
        } else if (s instanceof OffsetTime) {
            formattedDate = DateTimeFormatter.ISO_OFFSET_TIME.format((OffsetTime)s);
        } else if (s instanceof OffsetDateTime) {
            formattedDate = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format((OffsetDateTime)s);
        } else if (s instanceof ZonedDateTime) {
            formattedDate = DateTimeFormatter.ISO_ZONED_DATE_TIME.format((ZonedDateTime)s);
        } else if (s instanceof Instant) {
            formattedDate = DateTimeFormatter.ISO_INSTANT.format((Instant)s);
        } else {
            throw new CoercingParseLiteralException("Input is not a valid date type: " + input);
        }
        return new StringValue(formattedDate);
    }
}

