/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.core.utils;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class ServiceUtils {
    private static final Map<Class<? extends Supplier<?>>, ServiceLoader<?>> cacheMemory = new ConcurrentHashMap();

    public static <T> T getNewInstanceFromFactory(Class<? extends Supplier<T>> clazz) {
        ServiceLoader sl = cacheMemory.computeIfAbsent(clazz, ServiceLoader::load);
        if (sl.stream().count() != 1L) {
            throw new IllegalArgumentException(String.format("Expected exactly one implementation of %s. Found %d.", clazz.getName(), sl.stream().count()));
        }
        return ((Supplier)sl.iterator().next()).get();
    }

    private ServiceUtils() {
    }
}

