/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.vertx.dynamic;

import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClientBuilder;
import io.smallrye.graphql.client.impl.ErrorMessageProvider;
import io.smallrye.graphql.client.impl.GraphQLClientConfiguration;
import io.smallrye.graphql.client.impl.GraphQLClientsConfiguration;
import io.smallrye.graphql.client.impl.SmallRyeGraphQLClientMessages;
import io.smallrye.graphql.client.vertx.VertxClientOptionsHelper;
import io.smallrye.graphql.client.vertx.VertxManager;
import io.smallrye.graphql.client.vertx.dynamic.VertxDynamicGraphQLClient;
import io.smallrye.graphql.client.websocket.WebsocketSubprotocol;
import io.smallrye.mutiny.Uni;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

public class VertxDynamicGraphQLClientBuilder
implements DynamicGraphQLClientBuilder {
    private static final Logger log = Logger.getLogger(VertxDynamicGraphQLClientBuilder.class);
    private Vertx vertx;
    private WebClient webClient;
    private String url;
    private String websocketUrl;
    private Boolean executeSingleOperationsOverWebsocket;
    private String configKey;
    private final MultiMap headersMap = new HeadersMultiMap();
    private Map<String, Uni<String>> dynamicHeaders = new HashMap<String, Uni<String>>();
    private final Map<String, Object> initPayload = new HashMap<String, Object>();
    private WebClientOptions options;
    private List<WebsocketSubprotocol> subprotocols;
    private Integer subscriptionInitializationTimeout;
    private Boolean allowUnexpectedResponseFields;

    public VertxDynamicGraphQLClientBuilder() {
        this.headersMap.set("Content-Type", "application/json");
        this.subprotocols = new ArrayList<WebsocketSubprotocol>();
    }

    public VertxDynamicGraphQLClientBuilder vertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public VertxDynamicGraphQLClientBuilder webClient(WebClient client) {
        this.webClient = client;
        return this;
    }

    public VertxDynamicGraphQLClientBuilder header(String name, String value) {
        this.headersMap.set(name, value);
        return this;
    }

    public VertxDynamicGraphQLClientBuilder dynamicHeader(String name, Uni<String> value) {
        this.dynamicHeaders.put(name, value);
        return this;
    }

    public VertxDynamicGraphQLClientBuilder headers(Map<String, String> headers) {
        this.headersMap.setAll(headers);
        return this;
    }

    public VertxDynamicGraphQLClientBuilder initPayload(Map<String, Object> initPayload) {
        this.initPayload.putAll(initPayload);
        return this;
    }

    public VertxDynamicGraphQLClientBuilder options(WebClientOptions options) {
        this.options = options;
        return this;
    }

    public VertxDynamicGraphQLClientBuilder subprotocols(WebsocketSubprotocol ... subprotocols) {
        this.subprotocols.addAll(Arrays.asList(subprotocols));
        return this;
    }

    public DynamicGraphQLClientBuilder allowUnexpectedResponseFields(boolean value) {
        this.allowUnexpectedResponseFields = value;
        return this;
    }

    public DynamicGraphQLClientBuilder websocketInitializationTimeout(Integer timeoutInMilliseconds) {
        this.subscriptionInitializationTimeout = timeoutInMilliseconds;
        return this;
    }

    public VertxDynamicGraphQLClientBuilder url(String url) {
        this.url = url;
        return this;
    }

    public DynamicGraphQLClientBuilder websocketUrl(String url) {
        this.websocketUrl = url;
        return this;
    }

    public DynamicGraphQLClientBuilder executeSingleOperationsOverWebsocket(boolean value) {
        this.executeSingleOperationsOverWebsocket = value;
        return this;
    }

    public VertxDynamicGraphQLClientBuilder configKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public DynamicGraphQLClient build() {
        Vertx toUseVertx;
        GraphQLClientConfiguration persistentConfig;
        if (this.options == null) {
            this.options = new WebClientOptions();
        }
        if (this.configKey != null && (persistentConfig = GraphQLClientsConfiguration.getInstance().getClient(this.configKey)) != null) {
            this.applyConfig(persistentConfig);
        }
        if (this.url == null) {
            if (this.configKey == null) {
                throw SmallRyeGraphQLClientMessages.msg.urlNotConfiguredForProgrammaticClient();
            }
            throw ErrorMessageProvider.get().urlMissingErrorForNamedClient(this.configKey);
        }
        Vertx vertx = toUseVertx = this.vertx != null ? this.vertx : VertxManager.get();
        if (this.subprotocols == null || this.subprotocols.isEmpty()) {
            this.subprotocols = new ArrayList<WebsocketSubprotocol>(EnumSet.of(WebsocketSubprotocol.GRAPHQL_TRANSPORT_WS));
        }
        if (this.websocketUrl == null) {
            this.websocketUrl = this.url.replaceFirst("http", "ws");
        }
        if (this.executeSingleOperationsOverWebsocket == null) {
            this.executeSingleOperationsOverWebsocket = false;
        }
        if (this.allowUnexpectedResponseFields == null) {
            this.allowUnexpectedResponseFields = false;
        }
        return new VertxDynamicGraphQLClient(toUseVertx, this.webClient, this.url, this.websocketUrl, this.executeSingleOperationsOverWebsocket, this.headersMap, this.dynamicHeaders, this.initPayload, this.options, this.subprotocols, this.subscriptionInitializationTimeout, this.allowUnexpectedResponseFields);
    }

    private void applyConfig(GraphQLClientConfiguration configuration) {
        if (this.url == null && configuration.getUrl() != null) {
            this.url = configuration.getUrl();
        }
        if (this.websocketUrl == null && configuration.getWebsocketUrl() != null) {
            this.websocketUrl = configuration.getWebsocketUrl();
        }
        configuration.getHeaders().forEach((k, v) -> {
            if (!this.headersMap.contains(k)) {
                this.headersMap.set(k, v);
            }
        });
        configuration.getDynamicHeaders().forEach((k, v) -> {
            if (!this.dynamicHeaders.containsKey(k)) {
                this.dynamicHeaders.put((String)k, (Uni<String>)v);
            }
        });
        configuration.getInitPayload().forEach((k, v) -> {
            if (!this.initPayload.containsKey(k)) {
                this.initPayload.put((String)k, v);
            }
        });
        if (configuration.getWebsocketSubprotocols() != null) {
            configuration.getWebsocketSubprotocols().forEach(protocol -> {
                try {
                    WebsocketSubprotocol e = WebsocketSubprotocol.fromString((String)protocol);
                    this.subprotocols.add(e);
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)e);
                }
            });
        }
        if (this.subscriptionInitializationTimeout == null && configuration.getWebsocketInitializationTimeout() != null) {
            this.subscriptionInitializationTimeout = configuration.getWebsocketInitializationTimeout();
        }
        if (this.executeSingleOperationsOverWebsocket == null && configuration.getExecuteSingleOperationsOverWebsocket() != null) {
            this.executeSingleOperationsOverWebsocket = configuration.getExecuteSingleOperationsOverWebsocket();
        }
        if (this.allowUnexpectedResponseFields == null && configuration.getAllowUnexpectedResponseFields() != null) {
            this.allowUnexpectedResponseFields = configuration.getAllowUnexpectedResponseFields();
        }
        VertxClientOptionsHelper.applyConfigToVertxOptions((HttpClientOptions)this.options, configuration);
    }
}

