package io.smallrye.jwt.auth.principal;

import java.util.Locale;
import org.jose4j.jwt.consumer.InvalidJwtException;
import java.util.function.Function;
import java.io.Serializable;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.UnresolvableKeyException;
import java.lang.Throwable;
import io.smallrye.jwt.auth.principal.ParseException;
import java.lang.String;
import java.io.IOException;
import java.util.Arrays;
import io.smallrye.jwt.auth.principal.UnmatchedTokenKidException;

/**
 * Warning this class consists of generated code.
 */
public class PrincipalMessages_$bundle implements PrincipalMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected PrincipalMessages_$bundle() {}
    public static final PrincipalMessages_$bundle INSTANCE = new PrincipalMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String failedToVerifyToken$str() {
        return "SRJWT07000: Failed to verify a token";
    }
    @Override
    public final io.smallrye.jwt.auth.principal.ParseException failedToVerifyToken(final Throwable throwable) {
        final io.smallrye.jwt.auth.principal.ParseException result = new io.smallrye.jwt.auth.principal.ParseException(String.format(getLoggingLocale(), failedToVerifyToken$str()), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String claimNotFound$str() {
        return "SRJWT07001: No claim exists in sub, upn or preferred_username";
    }
    @Override
    public final InvalidJwtException claimNotFound(final Function<String, InvalidJwtException> fn) {
        final InvalidJwtException result = fn.apply(String.format(getLoggingLocale(), claimNotFound$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToLoadKey$str() {
        return "SRJWT07002: Failed to load a key from the key content";
    }
    @Override
    public final UnresolvableKeyException failedToLoadKey(final Throwable throwable) {
        final UnresolvableKeyException result = new UnresolvableKeyException(String.format(getLoggingLocale(), failedToLoadKey$str()), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToLoadKeyFromLocation$str() {
        return "SRJWT07003: Failed to load a key from %s";
    }
    @Override
    public final UnresolvableKeyException failedToLoadKeyFromLocation(final String location, final Throwable throwable) {
        final UnresolvableKeyException result = new UnresolvableKeyException(String.format(getLoggingLocale(), failedToLoadKeyFromLocation$str(), location), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToLoadKeyWhileResolving$str() {
        return "SRJWT07004: Failed to load a key from the key content while resolving";
    }
    @Override
    public final UnresolvableKeyException failedToLoadKeyWhileResolving() {
        final UnresolvableKeyException result = new UnresolvableKeyException(String.format(getLoggingLocale(), failedToLoadKeyWhileResolving$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToLoadKeyFromLocationWhileResolving$str() {
        return "SRJWT07005: Failed to load a key from %s property while resolving";
    }
    @Override
    public final UnresolvableKeyException failedToLoadKeyFromLocationWhileResolving(final String location) {
        final UnresolvableKeyException result = new UnresolvableKeyException(String.format(getLoggingLocale(), failedToLoadKeyFromLocationWhileResolving$str(), location));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTokenKid$str() {
        return "SRJWT07006: Invalid token 'kid' header";
    }
    @Override
    public final UnresolvableKeyException invalidTokenKid() {
        final UnresolvableKeyException result = new UnresolvableKeyException(String.format(getLoggingLocale(), invalidTokenKid$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String resourceNotFound$str() {
        return "SRJWT07007: No resource with the named %s location exists";
    }
    @Override
    public final IOException resourceNotFound(final String resourceName) {
        final IOException result = new IOException(String.format(getLoggingLocale(), resourceNotFound$str(), resourceName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIatExp$str() {
        return "SRJWT07008: Invalid 'iat' or 'exp' claim value";
    }
    @Override
    public final io.smallrye.jwt.auth.principal.ParseException invalidIatExp() {
        final io.smallrye.jwt.auth.principal.ParseException result = new io.smallrye.jwt.auth.principal.ParseException(String.format(getLoggingLocale(), invalidIatExp$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expExceeded$str() {
        return "SRJWT07009: The Expiration Time (exp=%s) claim value cannot be more than %d seconds in the future relative to Issued At (iat=%s) claim value";
    }
    @Override
    public final io.smallrye.jwt.auth.principal.ParseException expExceeded(final NumericDate exp, final long maxTimeToLiveSecs, final NumericDate iat) {
        final io.smallrye.jwt.auth.principal.ParseException result = new io.smallrye.jwt.auth.principal.ParseException(String.format(getLoggingLocale(), expExceeded$str(), exp, maxTimeToLiveSecs, iat));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingClaims$str() {
        return "SRJWT07010: Required claims are not present in the JWT";
    }
    @Override
    public final InvalidJwtException missingClaims(final Function<String, InvalidJwtException> fn) {
        final InvalidJwtException result = fn.apply(String.format(getLoggingLocale(), missingClaims$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String verificationKeyUnresolvable$str() {
        return "SRJWT07011: Verification key is unresolvable";
    }
    @Override
    public final io.smallrye.jwt.auth.principal.ParseException verificationKeyUnresolvable() {
        final io.smallrye.jwt.auth.principal.ParseException result = new io.smallrye.jwt.auth.principal.ParseException(String.format(getLoggingLocale(), verificationKeyUnresolvable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String decryptionKeyUnresolvable$str() {
        return "SRJWT07012: Decryption key is unresolvable";
    }
    @Override
    public final io.smallrye.jwt.auth.principal.ParseException decryptionKeyUnresolvable(final Throwable throwable) {
        final io.smallrye.jwt.auth.principal.ParseException result = new io.smallrye.jwt.auth.principal.ParseException(String.format(getLoggingLocale(), decryptionKeyUnresolvable$str()), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String encryptedTokenSequenceInvalid$str() {
        return "SRJWT07013: Encrypted token sequence is invalid";
    }
    @Override
    public final io.smallrye.jwt.auth.principal.ParseException encryptedTokenSequenceInvalid(final Throwable throwable) {
        final io.smallrye.jwt.auth.principal.ParseException result = new io.smallrye.jwt.auth.principal.ParseException(String.format(getLoggingLocale(), encryptedTokenSequenceInvalid$str()), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToLoadCertificates$str() {
        return "SRJWT07014: Failed to load X509 certificates";
    }
    @Override
    public final io.smallrye.jwt.auth.principal.ParseException failedToLoadCertificates() {
        final io.smallrye.jwt.auth.principal.ParseException result = new io.smallrye.jwt.auth.principal.ParseException(String.format(getLoggingLocale(), failedToLoadCertificates$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToVerifyIatExp$str() {
        return "SRJWT07015: The Expiration Time (exp=%s) claim value cannot be less than Issued At (iat=%s) claim value";
    }
    @Override
    public final io.smallrye.jwt.auth.principal.ParseException failedToVerifyIatExp(final NumericDate exp, final NumericDate iat) {
        final io.smallrye.jwt.auth.principal.ParseException result = new io.smallrye.jwt.auth.principal.ParseException(String.format(getLoggingLocale(), failedToVerifyIatExp$str(), exp, iat));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String encryptedTokenMissingContentType$str() {
        return "SRJWT07016: Encrypted token headers must contain a content type header";
    }
    @Override
    public final io.smallrye.jwt.auth.principal.ParseException encryptedTokenMissingContentType() {
        final io.smallrye.jwt.auth.principal.ParseException result = new io.smallrye.jwt.auth.principal.ParseException(String.format(getLoggingLocale(), encryptedTokenMissingContentType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String newJWTCallerPrincipalFactoryFailure$str() {
        return "SRJWT07017: New JWTCallerPrincipalFactory instance can not be created";
    }
    @Override
    public final io.smallrye.jwt.auth.principal.ParseException newJWTCallerPrincipalFactoryFailure(final Throwable throwable) {
        final io.smallrye.jwt.auth.principal.ParseException result = new io.smallrye.jwt.auth.principal.ParseException(String.format(getLoggingLocale(), newJWTCallerPrincipalFactoryFailure$str()), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tokenAgeExceeded$str() {
        return "SRJWT07018: The token age has exceeded %d seconds";
    }
    @Override
    public final io.smallrye.jwt.auth.principal.ParseException tokenAgeExceeded(final long tokenAge) {
        final io.smallrye.jwt.auth.principal.ParseException result = new io.smallrye.jwt.auth.principal.ParseException(String.format(getLoggingLocale(), tokenAgeExceeded$str(), tokenAge));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullKeyLocation$str() {
        return "SRJWT07019: Required key location is null";
    }
    @Override
    public final UnresolvableKeyException nullKeyLocation() {
        final UnresolvableKeyException result = new UnresolvableKeyException(String.format(getLoggingLocale(), nullKeyLocation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullKeyIdentifier$str() {
        return "SRJWT07020: Required key identifier is null";
    }
    @Override
    public final UnresolvableKeyException nullKeyIdentifier() {
        final UnresolvableKeyException result = new UnresolvableKeyException(String.format(getLoggingLocale(), nullKeyIdentifier$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unmatchedTokenKidException$str() {
        return "SRJWT07021: JWK set does not contain provided token 'kid'";
    }
    @Override
    public final io.smallrye.jwt.auth.principal.UnmatchedTokenKidException unmatchedTokenKidException() {
        final io.smallrye.jwt.auth.principal.UnmatchedTokenKidException result = new io.smallrye.jwt.auth.principal.UnmatchedTokenKidException(String.format(getLoggingLocale(), unmatchedTokenKidException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToParseToken$str() {
        return "SRJWT07022: Failed to parse a token";
    }
    @Override
    public final io.smallrye.jwt.auth.principal.ParseException failedToParseToken(final Throwable throwable) {
        final io.smallrye.jwt.auth.principal.ParseException result = new io.smallrye.jwt.auth.principal.ParseException(String.format(getLoggingLocale(), failedToParseToken$str()), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
