/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.impl;

import io.smallrye.jwt.build.JwtEncryptionException;
import io.smallrye.jwt.build.JwtException;
import io.smallrye.jwt.build.JwtSignatureException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="SRJWT", length=5)
interface ImplMessages {
    public static final ImplMessages msg = (ImplMessages)Messages.getBundle(ImplMessages.class);

    @Message(id=5000, value="Unsupported signature algorithm: %s")
    public JwtSignatureException unsupportedSignatureAlgorithm(String var1, @Cause Throwable var2);

    public JwtSignatureException unsupportedSignatureAlgorithm(String var1);

    @Message(id=5003, value="%s")
    public JwtEncryptionException joseSerializationError(String var1, @Cause Throwable var2);

    @Message(id=5004, value="Direct content encryption is currently not supported")
    public JwtEncryptionException directContentEncryptionUnsupported();

    @Message(id=5005, value="Unsupported key encryption algorithm: %s")
    public JwtEncryptionException unsupportedKeyEncryptionAlgorithm(String var1);

    @Message(id=5006, value="Unsupported content encryption algorithm: %s")
    public JwtEncryptionException unsupportedContentEncryptionAlgorithm(String var1);

    @Message(id=5007, value="Key encryption key can not be loaded from: %s")
    public IllegalArgumentException encryptionKeyCanNotBeLoadedFromLocation(String var1);

    @Message(id=5008, value="Please set 'smallrye.jwt.encrypt.key.location' or 'smallrye.jwt.encrypt.key' property")
    public IllegalArgumentException encryptionKeyNotConfigured();

    @Message(id=5009, value="")
    public JwtSignatureException signatureException(@Cause Throwable var1);

    @Message(id=5010, value="Inner JWT can not be created, 'smallrye.jwt.sign.key.location' is not set but the 'alg' header is: %s")
    public JwtSignatureException signKeyPropertyRequired(String var1);

    @Message(id=5011, value="None signature algorithm is currently not supported")
    public JwtSignatureException noneSignatureAlgorithmUnsupported();

    @Message(id=5012, value="Failure to create a signed JWT token: %s")
    public JwtSignatureException signJwtTokenFailed(String var1, @Cause Throwable var2);

    @Message(id=5013, value="JWK algorithm 'alg' value does not match a key type")
    public IllegalArgumentException algDoesNotMatchKeyType();

    @Message(id=5014, value="Only PrivateKey or SecretKey can be be used to sign a token")
    public IllegalArgumentException publicKeyBeingUsedForSign();

    @Message(id=5015, value="Failure to read the json content: %s")
    public JwtException readJsonFailure(String var1, @Cause Throwable var2);

    @Message(id=5016, value="Failure to parse JWK: %s")
    public JwtException failureToParseJWK(String var1, @Cause Throwable var2);

    @Message(id=5017, value="Failure to parse JWK Set: %s")
    public JwtException failureToParseJWKS(String var1, @Cause Throwable var2);

    @Message(id=5018, value="Key id 'kid' header value must be provided")
    public IllegalArgumentException kidRequired();

    @Message(id=5019, value="JWK set has no key with a key id 'kid' header '%s'")
    public IllegalArgumentException keyWithKidNotFound(String var1);

    @Message(id=5020, value="Signing key can not be loaded from: %s")
    public IllegalArgumentException signingKeyCanNotBeLoadedFromLocation(String var1, @Cause Throwable var2);

    @Message(id=5021, value="Please set 'smallrye.jwt.sign.key.location' or 'smallrye.jwt.sign.key' property")
    public IllegalArgumentException signKeyNotConfigured();

    @Message(id=5022, value="Failure to parse the JWT claims: %s")
    public JwtException failureToParseJWTClaims(String var1, @Cause Throwable var2);

    @Message(id=5024, value="Failure to read the private key: %s")
    public JwtException failureToReadPrivateKey(String var1, @Cause Throwable var2);

    @Message(id=5025, value="Failure to open the input stream from %s")
    public JwtException failureToOpenInputStreamFromJsonResName(String var1);

    @Message(id=5026, value="Failure to read the json content from %s: %s")
    public JwtException failureToReadJsonContentFromJsonResName(String var1, String var2, @Cause Throwable var3);

    @Message(id=5027, value="Failure to encrypt the token")
    public JwtEncryptionException encryptionException(@Cause Throwable var1);

    @Message(id=5028, value="Signing key can not be created from the loaded content")
    public IllegalArgumentException signingKeyCanNotBeCreatedFromContent();

    @Message(id=5029, value="Encryption key can not be created from the loaded content")
    public IllegalArgumentException encryptionKeyCanNotBeCreatedFromContent();

    @Message(id=5030, value="Signing key can not be read from the keystore")
    public IllegalArgumentException signingKeyCanNotBeReadFromKeystore(@Cause Throwable var1);

    @Message(id=5031, value="Encryption key can not be read from the keystore")
    public IllegalArgumentException encryptionKeyCanNotBeReadFromKeystore(@Cause Throwable var1);
}

