/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.exclusions;

import io.spring.gradle.dependencymanagement.DependencyManagementConfigurationContainer;
import io.spring.gradle.dependencymanagement.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.DependencyManagementExtension;
import io.spring.gradle.dependencymanagement.VersionConfiguringAction;
import io.spring.gradle.dependencymanagement.exclusions.ExclusionResolver;
import io.spring.gradle.dependencymanagement.exclusions.Exclusions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusionConfiguringAction
implements Action<ResolvableDependencies> {
    private final Logger log = LoggerFactory.getLogger(ExclusionConfiguringAction.class);
    private final DependencyManagementExtension dependencyManagementExtension;
    private final DependencyManagementContainer dependencyManagementContainer;
    private final DependencyManagementConfigurationContainer configurationContainer;
    private final Configuration configuration;
    private final ExclusionResolver exclusionResolver;
    private final VersionConfiguringAction versionConfiguringAction;

    public ExclusionConfiguringAction(DependencyManagementExtension dependencyManagementExtension, DependencyManagementContainer dependencyManagementContainer, DependencyManagementConfigurationContainer configurationContainer, Configuration configuration, ExclusionResolver exclusionResolver, VersionConfiguringAction versionConfiguringAction) {
        this.dependencyManagementExtension = dependencyManagementExtension;
        this.dependencyManagementContainer = dependencyManagementContainer;
        this.configurationContainer = configurationContainer;
        this.configuration = configuration;
        this.exclusionResolver = exclusionResolver;
        this.versionConfiguringAction = versionConfiguringAction;
    }

    public void execute(ResolvableDependencies resolvableDependencies) {
        if (this.dependencyManagementExtension.isApplyMavenExclusions()) {
            this.applyMavenExclusions(resolvableDependencies);
        }
    }

    private void applyMavenExclusions(ResolvableDependencies resolvableDependencies) {
        Set<ResolvedComponentResult> excludedDependencies = this.findExcludedDependencies();
        if (this.log.isInfoEnabled()) {
            this.log.info("Excluding " + String.valueOf(excludedDependencies));
        }
        ArrayList exclusions = new ArrayList();
        for (ResolvedComponentResult excludedDependency : excludedDependencies) {
            HashMap<String, String> exclusion = new HashMap<String, String>();
            exclusion.put("group", excludedDependency.getModuleVersion().getGroup());
            exclusion.put("module", excludedDependency.getModuleVersion().getName());
            exclusions.add(exclusion);
        }
        for (Dependency dependency : resolvableDependencies.getDependencies()) {
            if (!(dependency instanceof ModuleDependency)) continue;
            for (Map map : exclusions) {
                ((ModuleDependency)dependency).exclude(map);
            }
        }
    }

    private Set<ResolvedComponentResult> findExcludedDependencies() {
        Configuration configurationCopy = this.configurationContainer.newConfiguration((Dependency[])this.configuration.getAllDependencies().toArray((Object[])new Dependency[this.configuration.getAllDependencies().size()]));
        configurationCopy.getResolutionStrategy().eachDependency((Action)this.versionConfiguringAction);
        if (configurationCopy.getResolvedConfiguration().hasError()) {
            configurationCopy.getResolvedConfiguration().rethrowFailure();
        }
        ResolutionResult resolutionResult = configurationCopy.getIncoming().getResolutionResult();
        ResolvedComponentResult root = resolutionResult.getRoot();
        Set excludedDependencies = resolutionResult.getAllComponents();
        Set<ResolvedComponentResult> includedDependencies = this.determineIncludedComponents(root, this.exclusionResolver.resolveExclusions(excludedDependencies));
        excludedDependencies.removeAll(includedDependencies);
        return excludedDependencies;
    }

    private Set<ResolvedComponentResult> determineIncludedComponents(ResolvedComponentResult root, Map<String, Exclusions> pomExclusionsById) {
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(new Node(root, this.getId(root), new HashSet()));
        HashSet<ResolvedComponentResult> seen = new HashSet<ResolvedComponentResult>();
        HashSet<ResolvedComponentResult> includedComponents = new HashSet<ResolvedComponentResult>();
        while (!queue.isEmpty()) {
            Node node = (Node)queue.remove();
            includedComponents.add(node.component);
            for (DependencyResult dependency : node.component.getDependencies()) {
                ResolvedComponentResult child;
                String childId;
                if (!(dependency instanceof ResolvedDependencyResult) || node.excluded(childId = this.getId(child = ((ResolvedDependencyResult)dependency).getSelected())) || !seen.add(child)) continue;
                queue.add(new Node(child, childId, this.getChildExclusions(node, childId, pomExclusionsById)));
            }
        }
        return includedComponents;
    }

    private Set<String> getChildExclusions(Node parent, String childId, Map<String, Exclusions> pomExclusionsById) {
        HashSet<String> childExclusions = new HashSet<String>(parent.exclusions);
        this.addAllIfPossible(childExclusions, this.dependencyManagementContainer.getExclusions(this.configuration).exclusionsForDependency(childId));
        Exclusions exclusionsInPom = pomExclusionsById.get(parent.id);
        if (exclusionsInPom != null) {
            this.addAllIfPossible(childExclusions, exclusionsInPom.exclusionsForDependency(childId));
        }
        return childExclusions;
    }

    private void addAllIfPossible(Set<String> current, Set<String> addition) {
        if (addition != null) {
            current.addAll(addition);
        }
    }

    private String getId(ResolvedComponentResult component) {
        return component.getModuleVersion().getGroup() + ":" + component.getModuleVersion().getName();
    }

    private static class Node {
        private final ResolvedComponentResult component;
        private final String id;
        private final Set<String> exclusions;

        private Node(ResolvedComponentResult component, String id, Set<String> exclusions) {
            this.component = component;
            this.id = id;
            this.exclusions = exclusions;
        }

        private boolean excluded(String id) {
            return this.exclusions != null && this.exclusions.contains(id);
        }
    }
}

