/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal;

import io.spring.gradle.dependencymanagement.internal.Exclusion;
import io.spring.gradle.dependencymanagement.internal.Exclusions;
import io.spring.gradle.dependencymanagement.internal.pom.Coordinates;
import io.spring.gradle.dependencymanagement.internal.pom.Dependency;
import io.spring.gradle.dependencymanagement.internal.pom.Pom;
import io.spring.gradle.dependencymanagement.internal.pom.PomReference;
import io.spring.gradle.dependencymanagement.internal.pom.PomResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;

class ExclusionResolver {
    private static final Set<String> IGNORED_SCOPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("provided", "test")));
    private final Map<String, Exclusions> exclusionsCache = new HashMap<String, Exclusions>();
    private final PomResolver pomResolver;

    ExclusionResolver(PomResolver pomResolver) {
        this.pomResolver = pomResolver;
    }

    Map<String, Exclusions> resolveExclusions(Collection<ResolvedComponentResult> resolvedComponents) {
        ArrayList<PomReference> pomReferences = new ArrayList<PomReference>();
        HashMap<String, Exclusions> exclusionsById = new HashMap<String, Exclusions>();
        for (ResolvedComponentResult resolvedComponent : resolvedComponents) {
            if (resolvedComponent.getId() instanceof ProjectComponentIdentifier || resolvedComponent.getModuleVersion().getGroup() == null || resolvedComponent.getModuleVersion().getName() == null) continue;
            String id = resolvedComponent.getModuleVersion().getGroup() + ":" + resolvedComponent.getModuleVersion().getName();
            Exclusions exclusions = this.exclusionsCache.get(id);
            if (exclusions != null) {
                exclusionsById.put(id, exclusions);
                continue;
            }
            pomReferences.add(new PomReference(new Coordinates(resolvedComponent.getModuleVersion().getGroup(), resolvedComponent.getModuleVersion().getName(), resolvedComponent.getModuleVersion().getVersion())));
        }
        List<Pom> poms = this.pomResolver.resolvePomsLeniently(pomReferences);
        for (Pom pom : poms) {
            String id = pom.getCoordinates().getGroupId() + ":" + pom.getCoordinates().getArtifactId();
            Exclusions exclusions = this.collectExclusions(pom);
            this.exclusionsCache.put(id, exclusions);
            exclusionsById.put(id, exclusions);
        }
        return exclusionsById;
    }

    private Exclusions collectExclusions(Pom pom) {
        Exclusions exclusions = new Exclusions();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(pom.getManagedDependencies());
        dependencies.addAll(pom.getDependencies());
        for (Dependency dependency : dependencies) {
            if (dependency.getExclusions() == null || dependency.isOptional() || IGNORED_SCOPES.contains(dependency.getScope())) continue;
            String dependencyId = dependency.getCoordinates().getGroupId() + ":" + dependency.getCoordinates().getArtifactId();
            exclusions.add(dependencyId, new HashSet<Exclusion>(dependency.getExclusions()));
        }
        return exclusions;
    }
}

