/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.maven;

import io.spring.gradle.dependencymanagement.internal.DependencyManagementConfigurationContainer;
import io.spring.gradle.dependencymanagement.internal.maven.ConfigurationModelResolver;
import io.spring.gradle.dependencymanagement.internal.maven.PlatformCategoryAttributeConfigurer;
import io.spring.gradle.dependencymanagement.internal.maven.PropertiesModelInterpolator;
import io.spring.gradle.dependencymanagement.internal.maven.RelaxedModelValidator;
import io.spring.gradle.dependencymanagement.internal.properties.PropertySource;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Model;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.DefaultModelBuilder;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.DefaultModelBuilderFactory;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.DefaultModelBuildingRequest;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.FileModelSource;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelBuildingException;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelBuildingResult;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelCache;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelProblem;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.resolution.ModelResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EffectiveModelBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EffectiveModelBuilder.class);
    private final ModelResolver modelResolver;

    EffectiveModelBuilder(Project project, DependencyManagementConfigurationContainer configurationContainer, PlatformCategoryAttributeConfigurer attributeConfigurer) {
        this.modelResolver = new ConfigurationModelResolver(project, configurationContainer, attributeConfigurer);
    }

    List<Model> buildModels(List<ModelInput> inputs) {
        ArrayList<Model> models = new ArrayList<Model>();
        InMemoryModelCache cache = new InMemoryModelCache();
        for (ModelInput input : inputs) {
            models.add(this.buildModel(input, cache));
        }
        return models;
    }

    private Model buildModel(ModelInput input, InMemoryModelCache cache) {
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
        request.setSystemProperties(System.getProperties());
        request.setModelSource(new FileModelSource(input.pom));
        request.setModelResolver(this.modelResolver);
        request.setModelCache(cache);
        try {
            ModelBuildingResult result = this.createModelBuilder(input.properties).build(request);
            List<ModelProblem> errors = this.extractErrors(result.getProblems());
            if (!errors.isEmpty()) {
                this.reportErrors(errors, input.pom);
            }
            return result.getEffectiveModel();
        }
        catch (ModelBuildingException ex) {
            logger.debug("Model building failed", (Throwable)ex);
            this.reportErrors(this.extractErrors(ex.getProblems()), input.pom);
            return ex.getResult().getEffectiveModel();
        }
    }

    private List<ModelProblem> extractErrors(List<ModelProblem> problems) {
        ArrayList<ModelProblem> errors = new ArrayList<ModelProblem>();
        for (ModelProblem problem : problems) {
            if (problem.getSeverity() != ModelProblem.Severity.ERROR) continue;
            errors.add(problem);
        }
        return errors;
    }

    private void reportErrors(List<ModelProblem> errors, File file) {
        StringBuilder message = new StringBuilder("Errors occurred while build effective model from " + file + ":");
        for (ModelProblem error : errors) {
            message.append("\n\t" + error.getMessage() + " in " + error.getModelId());
        }
        logger.error(message.toString());
    }

    private DefaultModelBuilder createModelBuilder(PropertySource properties) {
        DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
        modelBuilder.setModelInterpolator(new PropertiesModelInterpolator(properties));
        modelBuilder.setModelValidator(new RelaxedModelValidator());
        return modelBuilder;
    }

    private static final class InMemoryModelCache
    implements ModelCache {
        private final Map<Key, Object> cache = new ConcurrentHashMap<Key, Object>();

        private InMemoryModelCache() {
        }

        @Override
        public Object get(String groupId, String artifactId, String version, String tag) {
            return this.cache.get(new Key(groupId, artifactId, version, tag));
        }

        @Override
        public void put(String groupId, String artifactId, String version, String tag, Object item) {
            this.cache.put(new Key(groupId, artifactId, version, tag), item);
        }

        private static final class Key {
            private final String groupId;
            private final String artifactId;
            private final String version;
            private final String tag;

            private Key(String groupId, String artifactId, String version, String tag) {
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
                this.tag = tag;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                if (!this.groupId.equals(other.groupId)) {
                    return false;
                }
                if (!this.artifactId.equals(other.artifactId)) {
                    return false;
                }
                if (!this.version.equals(other.version)) {
                    return false;
                }
                return this.tag.equals(other.tag);
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.groupId.hashCode();
                result = 31 * result + this.artifactId.hashCode();
                result = 31 * result + this.version.hashCode();
                result = 31 * result + this.tag.hashCode();
                return result;
            }
        }
    }

    static class ModelInput {
        private final File pom;
        private final PropertySource properties;

        ModelInput(File pom, PropertySource properties) {
            this.pom = pom;
            this.properties = properties;
        }
    }
}

